#!/bin/sh

echo "Install MongoDB"

has_mongodb=`rpm -qa |grep mongo`
if [ ! -z "${has_mongodb}" ]; then
    echo "MongoDB is installed, no need to install again."
    exit
fi

# Install mongodb from RPMs
rpm -Uvh rpms/mongodb-org-database-tools-extra-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-mongosh-1.1.9.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-mongos-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-server-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-shell-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-database-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-database-tools-100.5.1.x86_64.rpm
rpm -Uvh rpms/mongodb-org-tools-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-5.0.5-1.el7.x86_64.rpm

systemctl start mongod

# enable service to restart on boot
systemctl enable mongod

# create user and password
# Default username & password is in config/mongodb/create-user.js
sh scripts/config_mongodb.sh
