#!/bin/bash
escape_slash() {
    echo $1 | sed 's/\//\\\//g'
}

with_archive="false"

while getopts 'afh' OPTION; do
    case "$OPTION" in
        a)
            with_archive="true"
            ;;
        f)
            force_overwriting=1
            ;;
        h)
            echo "Usage: $(basename $0) [-a] [-f]"
            exit 1
            ;;
        ?)
            ;;
    esac
done

if [ ! -f "/opt/caton/cydex3/node/config.ini" ] || [ "$force_overwriting" == "1" ]; then
    if [ "$with_archive" == "true" ]; then
        echo -e "\n\n[Cydex] Configuring (/opt/caton/cydex3/node/config.ini) for Node service with archive mode enabled:"
    else
        echo -e "\n\n[Cydex] Configuring (/opt/caton/cydex3/node/config.ini) for Node service:"
    fi

    unset -v storage_type
    while ! [[ "$storage_type" =~ ^(fs|nas)$ ]]; do
        read -e -p " * Please specify Nearline Storage type (fs/nas): " storage_type
    done

    if [ "$storage_type" == "nas" ]; then
        read -e -p " * Please make sure your NAS storage has been successfully mounted. Continue? (y/N) " answer
        if [ "$answer" != "Y" ] && [ "$answer" != "y" ]; then
            echo "Abort"
            exit 1
        fi
    fi

    unset -v node_mnt_path
    while [ -z $node_mnt_path ]; do
        read -e -p " * Please input Nearline Storage mount path ([s1] => mnt_path, please specify an absolute path): " node_mnt_path
    done

    if [ "$with_archive" == "true" ]; then
        unset -v retrieving_tmp_path
        read -e -p " * Please input temporary path for retrieving ([archive] => tmp_path, please specify an absolute path): " -i "/cydex_tmp/" retrieving_tmp_path
    fi

    sed -e "s/{{S1_TYPE}}/`escape_slash $storage_type`/g" \
        -e "s/{{S1_MNT_PATH}}/`escape_slash $node_mnt_path`/g" \
        -e "s/{{ARCHIVE_ENABLED}}/`escape_slash $with_archive`/g" \
        -e "s/{{RETRIEVING_TMP_PATH}}/`escape_slash $retrieving_tmp_path`/g" \
        /opt/caton/cydex3/node/config_sample.ini  > /opt/caton/cydex3/node/config.ini

    echo ""
    echo "[Cydex] Node service successfully configured."
    echo "    To update, you may modify file"
    echo "        /opt/caton/cydex3/node/config.ini"
    echo "    and run:"
    echo "        systemctl restart cydex3-node"
    echo ""
fi

systemctl enable cydex3-node
systemctl start cydex3-node
