#!/bin/bash

escape_slash() {
    echo $1 | sed 's/\//\\\//g'
}

while getopts 'fh' OPTION; do
    case "$OPTION" in
        f)
            force_overwriting=1
            ;;
        h)
            echo "Usage: $(basename $0) [-a] [-f]"
            exit 1
            ;;
        ?)
            ;;
    esac
done

if [ ! -f "/opt/caton/cydex3/archive_consumer/config.ini" ] || [ "$force_overwriting" == "1" ]; then
    echo -e "\n\n[Cydex] Configuring (/opt/caton/cydex3/archive_consumer/config.ini) for Archive Consumer service\n"

    unset -v storage_type
    while ! [[ "$storage_type" =~ ^(fs|nas|s3)$ ]]; do
        read -e -p " * Please specify Archive Storage type (fs/nas/s3): " storage_type
    done

    if [ "$storage_type" == "nas" ]; then
        read -e -p " * Please make sure your NAS storage has been successfully mounted. Continue? (y/N) " answer
        if [ "$answer" != "Y" ] && [ "$answer" != "y" ]; then
            echo "Abort"
            exit 1
        fi
    fi

    read -e -p " * Please input archive path ([archive] => archive_path, please specify an absolute path): " -i "/archive_path/" archive_path
    
    archive_s3_enabled="false"
    archive_s3_region="<region>"
    archive_s3_access_key_id="<access_key_id>"
    archive_s3_secret_access_key="<secret_access_key>"
    archive_s3_bucket="<bucket>"
    archive_s3_endpoint="<endpoint>"
    archive_s3_disable_ssl="true"
    archive_s3_force_virtual_hosted_style="false"
    if [ "$storage_type" == "s3" ]; then
        archive_s3_enabled="true"
        read -e -p " * Please input S3 bucket region ([archive_s3] => region): " archive_s3_region
        read -e -p " * Please input S3 bucket access key ID ([archive_s3] => access_key_id): " archive_s3_access_key_id
        read -e -p " * Please input S3 bucket access secret ([archive_s3] => secret_access_key): " archive_s3_secret_access_key
        read -e -p " * Please input S3 bucket name ([archive_s3] => bucket): " archive_s3_bucket
        read -e -p " * Please input S3 bucket endpoint ([archive_s3] => endpoint): " archive_s3_endpoint
        read -e -p " * Do you want to disable SSL for S3 connection? ([archive_s3] => disable_ssl) (Y/n) " answer
        if [ "$answer" == "n" ] || [ "$answer" == "N" ]; then
            archive_s3_disable_ssl="false"
        fi
        echo "   disable_ssl=$archive_s3_disable_ssl"
        read -e -p " * Does your S3 storage mandatorily require virtual hosted style? ([archive_s3] => force_virtual_hosted_style) (y/N) " answer
        if [ "$answer" == "y" ] || [ "$answer" == "Y" ]; then
            archive_s3_force_virtual_hosted_style="true"
        fi
        echo "   force_virtual_hosted_style=$archive_s3_force_virtual_hosted_style"
    fi

    sed -e "s/{{ARCHIVE_PATH}}/`escape_slash $archive_path`/g" \
        -e "s/{{ARCHIVE_S3_ENABLED}}/`escape_slash $archive_s3_enabled`/g" \
        -e "s/{{ARCHIVE_S3_REGION}}/`escape_slash $archive_s3_region`/g" \
        -e "s/{{ARCHIVE_S3_ACCESS_KEY_ID}}/`escape_slash $archive_s3_access_key_id`/g" \
        -e "s/{{ARCHIVE_S3_SECRET_ACCESS_KEY}}/`escape_slash $archive_s3_secret_access_key`/g" \
        -e "s/{{ARCHIVE_S3_BUCKET}}/`escape_slash $archive_s3_bucket`/g" \
        -e "s/{{ARCHIVE_S3_ENDPOINT}}/`escape_slash $archive_s3_endpoint`/g" \
        -e "s/{{ARCHIVE_S3_DISABLE_SSL}}/`escape_slash $archive_s3_disable_ssl`/g" \
        -e "s/{{ARCHIVE_S3_FORCE_VIRTUAL_HOSTED}}/`escape_slash $archive_s3_force_virtual_hosted_style`/g" \
        /opt/caton/cydex3/archive_consumer/config_sample.ini  > /opt/caton/cydex3/archive_consumer/config.ini
    
    echo ""
    echo "[Cydex] Archive Consumer service successfully configured."
    echo "    To update, you may modify file"
    echo "        /opt/caton/cydex3/archive_consumer/config.ini"
    echo "    and run:"
    echo "        systemctl restart cydex3-archive-consumer"
    echo ""
fi

systemctl enable cydex3-archive-consumer
systemctl start cydex3-archive-consumer >/dev/null 2>&1
