#/bin/bash

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -a, --with-archive    Install Cydex with Archive Mode"
}

unset with_archive
while getopts 'a-:' OPTION; do
    case "$OPTION" in
        a)
            with_archive=1
            ;;
        -)
            case "${OPTARG}" in
                with-archive)
                    with_archive=1
                    ;;
                *)
                    show_help
                    exit 1
                    ;;
            esac
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.4.1\n\n\n"

echo "This script will install or upgrade Cydex3-zone and Cydex3-node services on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

echo -e "\n"
echo "[Cydex] Stop Zone ... "
systemctl stop cydex3-zone > /dev/null 2>&1

echo -e "\n"
echo "[Cydex] Install system components ... "
yum update -y
yum install -y epel-release

if rpm -q nginx >/dev/null 2>&1; then
    echo "This script will Reinstall Nginx services on this host !!!"
    echo -e "Continue Reinstalling Nginx? (Y/n) \c "
    read answer
    if ([ $answer == "Y" ] || [ $answer == "y" ]); then
        systemctl stop nginx
        yum remove -y nginx
        yum install -y nginx
    fi
else
    yum install -y nginx
fi

yum install -y redis
yum install -y iptables-services
sh scripts/install_mysql.sh

if [ "$with_archive" == "1" ]; then
    # Install AWS CLI
    sh scripts/install_aws_cli.sh

    # Install MongoDB
    sh scripts/install_mongodb.sh

    # install RabbitMQ
    sh scripts/install_rabbitmq.sh
fi

echo -e "\n"
echo "[Cydex] Install Cydex components ... "
pkgs=`ls cydex_rpms/*zone*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done
pkgs=`ls cydex_rpms/*node*.rpm`
for pkg in $pkgs
do
	rpm -Uvh $pkg
done

if [ "$with_archive" == "1" ]; then
    echo -e "\n"
    echo "[Cydex] Install Cydex Archive components ... "
    pkgs=`ls cydex_archive_rpms/*.rpm`
    for pkg in $pkgs
    do
        rpm -Uvh --force $pkg
    done
fi

echo -e "\n"
echo "[Cydex] Config system and Cydex ... "
sh scripts/disable_selinux.sh
sh scripts/config_zone_nginx.sh
sh scripts/config_redis.sh
sh scripts/config_zone_mysql.sh
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh
sh scripts/config_iptables.sh
sh scripts/config_zone_center.sh
sh scripts/config_zone_key.sh
if [ "$with_archive" == "1" ]; then
    sh scripts/config_zone_archive.sh
    sh scripts/config_node.sh -a
    sh scripts/config_archive.sh

    sh scripts/start_archive.sh
else
    sh scripts/config_node.sh
fi

echo -e "\n"
echo "[Cydex] Start Zone ... "
systemctl stop cydex3-zone > /dev/null 2>&1

echo -e "\n"
echo "***********************************"
echo "* Cydex zone is installed successfully. "
echo "***********************************"
echo -e "\n"
echo -e "\n"
