Install
-------
Use root or 'sudo' to do the following:

# install all cydex services

./install.sh

After installation is completed don't forget to configure `node` copying the config_sample.ini, you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
    systemctl start cydex3-zone
```

To automatically start Cydex3 node and Zone on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
 sudo systemctl enable cydex3-zone.service
```

# install zone standalone with node service
./install_zone.sh

After installation is completed don't forget to configure `node` copying the config_sample.ini, you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
    systemctl start cydex3-zone
```

To automatically start Cydex3 node and Zone on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
 sudo systemctl enable cydex3-zone.service
```


# install node standalone service
./install_node.sh

After installation is completed don't forget to configure `node` copying the config_sample.ini, you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
```

To automatically start Cydex3 node and Zone on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
```


# install all cydex services with archive mode
./install_archive.sh

After installation is completed don't forget to configure `node` and `archive-consumer` by copying the config_sample.ini. you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
```
    cp /opt/caton/cydex3/archive_consumer/config_sample.ini /opt/caton/cydex3/archive_consumer/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
    systemctl start cydex3-zone
    systemctl start cydex3-archive-consumer
```

To automatically start Cydex3 node, Zone and archive on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
 sudo systemctl enable cydex3-zone.service
 sudo systemctl enable cydex3-archive-consumer.service
```

# install all cydex services with user login configured to authenticate via LDAP (Microsoft AD)
./install_ldap.sh

After installation is completed don't forget to configure `node` by copying the config_sample.ini. you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
    systemctl start cydex3-zone
```

To automatically start Cydex3 node, Zone and archive on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
 sudo systemctl enable cydex3-zone.service
```

# install zone standalone with node service (with archive)
./install_archive_zone.sh

After installation is completed don't forget to configure `node` and `archive-consumer` by copying the config_sample.ini. you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
```
    cp /opt/caton/cydex3/archive_consumer/config_sample.ini /opt/caton/cydex3/archive_consumer/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
    systemctl start cydex3-zone
    systemctl start cydex3-archive-consumer
```

To automatically start Cydex3 node and Zone on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
 sudo systemctl enable cydex3-zone.service
 sudo systemctl enable cydex3-archive-consumer.service
```

# install node standalone service (with archive)
./install_archive_node.sh

After installation is completed don't forget to configure `node` and `archive-consumer` copying the config_sample.ini, you can use the following command

```
    cp /opt/caton/cydex3/node/config_sample.ini /opt/caton/cydex3/node/config.ini
```
```
    cp /opt/caton/cydex3/archive_consumer/config_sample.ini /opt/caton/cydex3/archive_consumer/config.ini
```
after configuration is completed, start the services

```
    systemctl start cydex3-node
    systemctl start cydex3-archive-consumer
```

To automatically start Cydex3 node and Zone on boot use the commands below:

```
 sudo systemctl enable cydex3-node.service
 sudo systemctl enable cydex3-archive-consumer.service
```

Uninstall
---------
Use root or 'sudo' to do the following:

    # uninstall all cydex services
	./uninstall.sh
