#/bin/bash

echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.3.3\n\n\n"

echo "This script will install or upgrade Cydex3-node service standalone on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

echo -e "\n"
echo "[Cydex] Stop Node ... "
systemctl stop cydex3-node > /dev/null 2>&1

echo -e "\n"
echo "[Cydex] Install system components ... "
yum update -y
yum install -y epel-release
yum install -y iptables-services

echo -e "\n"
echo "[Cydex] Install Cydex node components ... "
pkgs=`ls cydex_rpms/*node*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done

echo -e "\n"
echo "[Cydex] Install Cydex Archive components ... "
pkgs=`ls cydex_archive_rpms/*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done

echo -e "\n"
echo "[Cydex] Config system and Cydex node ... "
sh scripts/disable_selinux.sh
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh

# Install AWS CLI
sh scripts/install_aws_cli.sh

# install RabbitMQ
sh scripts/install_rabbitmq.sh

sh scripts/start_archive.sh

echo -e "\n"
echo "***********************************"
echo "* Cydex node is installed successfully. "
echo "* DON'T FORGET to config 'cydex3-node' and run it !!!" 
echo "* DON'T FORGET to config 'cydex3-archive-consumer' and run it !!!" 
echo "***********************************"
echo -e "\n"
echo -e "\n"
