#/bin/bash

echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.3.3\n\n\n"

echo "This script will install or update all Cydex3 services on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

sh scripts/stop_cydex.sh

systemctl stop firewalld
systemctl disable firewalld

echo -e "\n"
echo "[Cydex] Install system components ... "
yum update -y
yum install -y epel-release unzip

if rpm -q nginx >/dev/null 2>&1; then
    echo "This script will Reinstall Nginx services on this host !!!"
    echo -e "Continue Reinstalling Nginx? (Y/n) \c "
    read answer
    if ([ $answer == "Y" ] || [ $answer == "y" ]); then
        systemctl stop nginx
        yum remove -y nginx
        yum install -y nginx
    fi
else
    yum install -y nginx
fi

yum install -y redis
yum install -y iptables-services

# Install MYSQL
sh scripts/install_mysql.sh
# Install AWS CLI
sh scripts/install_aws_cli.sh
# Install MongoDB
sh scripts/install_mongodb.sh
# install RabbitMQ
sh scripts/install_rabbitmq.sh

echo -e "\n"
echo "[Cydex] Install Cydex components ... "
pkgs=`ls cydex_rpms/*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done

echo -e "\n"
echo "[Cydex] Install Cydex Archive components ... "
pkgs=`ls cydex_archive_rpms/*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done


echo -e "\n"
echo "[Cydex] Config system and Cydex ... "
sh scripts/disable_selinux.sh
sh scripts/config_nginx.sh
sh scripts/config_redis.sh
sh scripts/config_mysql.sh
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh
sh scripts/config_iptables.sh
sh scripts/config_zone_archive.sh
sh scripts/release.sh

echo -e "\n"
echo "[Cydex] Start Cydex ... "
sh scripts/start_cydex.sh
sh scripts/start_archive.sh

echo -e "\n"
echo "***********************************"
echo "* Cydex is installed successfully. "
echo "* DON'T FORGET to config 'cydex3-node' and run it !!!" 
echo "* DON'T FORGET to config 'cydex3-archive-consumer' and run it !!!" 
echo "***********************************"
echo -e "\n"
echo -e "\n"
