#/bin/bash

# Verify installed services
aws_directory=/usr/local/aws-cli
echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.3.1\n\n\n"

echo "This script will Uninstall the following components:"
echo " - Cydex3"
if rpm -q mysql-community-server >/dev/null 2>&1; then
    echo " - Mysql"
fi
if rpm -q nginx >/dev/null 2>&1; then
    echo " - Nginx"
fi
if rpm -q mongodb-org >/dev/null 2>&1; then
    echo " - MongoDB"
fi
if rpm -q redis >/dev/null 2>&1; then
    echo " - Redis"
fi
if rpm -q rabbitmq-server >/dev/null 2>&1; then
    echo " - RabbitMQ"
fi

if [ -d "${aws_directory}" ]; then
    echo " - AWS Cli"
fi
echo -e "\n\n"
echo -e "This action cannot be undone, Do you want to Procceed? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

# Start Uninstall p[roccess
echo -e "\n"
sh scripts/stop_cydex.sh

echo -e "\n"
echo "[Cydex] Stopping System components ... "
systemctl stop mysqld >/dev/null 2>&1
systemctl stop redis >/dev/null 2>&1
systemctl stop nginx >/dev/null 2>&1
systemctl stop mongod >/dev/null 2>&1
systemctl stop rabbitmq-server >/dev/null 2>&1


echo -e "\n"
echo "[Cydex] Disabling Cydex components ... "
systemctl disable cydex3-admin >/dev/null 2>&1
systemctl disable cydex3-company >/dev/null 2>&1
systemctl disable cydex3-data >/dev/null 2>&1
systemctl disable cydex3-manager >/dev/null 2>&1
systemctl disable cydex3-node >/dev/null 2>&1
systemctl disable cydex3-notification >/dev/null 2>&1
systemctl disable cydex3-transfer >/dev/null 2>&1
systemctl disable cydex3-zone >/dev/null 2>&1
systemctl disable cydex3-archive-producer >/dev/null 2>&1
systemctl disable cydex3-archive-consumer >/dev/null 2>&1

echo -e "\n"
echo "[Cydex] Uninstalling Cydex components ... "
rpm -e --nodeps `rpm -qa | grep "cydex"` >/dev/null 2>&1
rm /opt/caton/cydex3 -rf

# remove mysql if any
if rpm -q mysql-community-server >/dev/null 2>&1; then
    echo -e "\n"
    echo "[Cydex] Uninstalling Mysql ... "
    rpm -e --nodeps `rpm -qa | grep "mysql"` >/dev/null 2>&1
    rm /var/log/mysqld.log -f
    rm /var/lib/mysql/ -rf
    rm /var/run/mysqld/mysqld.pid -f
    rm /etc/my.cnf -f
fi

# remove Redis if any
if rpm -q redis >/dev/null 2>&1; then
    echo -e "\n"
    echo "[Cydex] Uninstalling Redis ... "
    rpm -e --nodeps `rpm -qa | grep "redis"` >/dev/null 2>&1
fi

# remove Nginx if any
if rpm -q nginx >/dev/null 2>&1; then
    echo -e "\n"
    echo "[Cydex] Uninstalling Nginx ... "
    rpm -e --nodeps `rpm -qa | grep "nginx"` >/dev/null 2>&1
    rm /etc/nginx/nginx.conf -f
    rm /etc/nginx/conf.d/cydex*.conf -f
fi

# remove MongoDb if any
if rpm -q mongodb-org >/dev/null 2>&1; then
    echo -e "\n"
    echo "[Cydex] Uninstalling MongoDB ... "
    rpm -e --nodeps `rpm -qa | grep "mongo"` >/dev/null 2>&1
    rm -r /var/log/mongodb >/dev/null 2>&1
    rm -r /var/lib/mongo >/dev/null 2>&1
fi

# remove RabbitMQ if any
if rpm -q rabbitmq-server >/dev/null 2>&1; then
    echo -e "\n"
    echo "[Cydex] Uninstalling RabbitMQ ... "
    rpm -e --nodeps `rpm -qa | grep "rabbitmq"` >/dev/null 2>&1
    rm -r /var/log/rabbitmq >/dev/null 2>&1
    rm -r /var/lib/rabbitmq >/dev/null 2>&1
    rm -r /etc/rabbitmq >/dev/null 2>&1
fi

# remove AWS Cli if any
if [ -d "${aws_directory}" ]; then
    echo -e "\n"
    echo "[Cydex] Uninstalling AWS Cli ... "
    rm /usr/local/bin/aws >/dev/null 2>&1
    rm /usr/local/bin/aws_completer >/dev/null 2>&1
    rm -rf /usr/local/aws-cli >/dev/null 2>&1
fi


echo -e "\n"
echo "***********************************"
echo "* Cydex was removed successfully. *"
echo "***********************************"
echo -e "\n"
echo -e "\n"
