#!/bin/sh

echo "Install mysql server"

has_mysql=`rpm -qa |grep mysql`
if [ ! -z "${has_mysql}" ]; then
    echo "Mysql is installed, no need to install again."
    exit
fi

if [ ! -d ./rpms ]; then
    echo "There is no rpms found, please contact to the Cydex support."
    exit 1
fi

if [ ! -f ./rpms/mysql-community-server-5.7.17-1.el7.x86_64.rpm ]; then
    echo "There is no mysql rpms found, please contact to the Cydex support."
    exit 1
fi

yum -y remove mariadb-libs*

yum -y localinstall ./rpms/mysql-community-common-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-libs-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-libs-compat-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-client-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-server-5.7.17-1.el7.x86_64.rpm
