#!/bin/bash


echo "[Cydex] Initial mysql for Zone"

PASSWORD="Caton_123"

has_cydex_db=`mysql -u root -p$PASSWORD -e "SELECT * FROM information_schema.SCHEMATA where SCHEMA_NAME='db_cydex';" |wc -l`
if [ ${has_cydex_db} -gt 0 ]; then
    echo "Mysql is initialed for cydex zone, do the migratation."
    sleep 1
    sh scripts/migrations/migrate_mysql_zone.sh
    exit
fi

systemctl stop mysqld

if [ ! -f /etc/my.cnf.backup ]; then
    mv /etc/my.cnf /etc/my.cnf.backup
fi

cp -r config/my.cnf /etc/my.cnf
mv /var/log/mysqld.log /var/log/mysqld.log.backup >/dev/null 2>&1

systemctl enable mysqld
systemctl start mysqld

sleep 3

# initial the root password
## get the random password
orig_password=`cat /var/log/mysqld.log | grep "A temporary password" | awk -F "root@localhost: " '{print $2}'`
mysqladmin -u root -p${orig_password} password $PASSWORD >/dev/null 2>&1

echo "[Cydex] db: create databases for Cydex zone"
# create databases
mysql -u root -p$PASSWORD -e "CREATE DATABASE db_zone DEFAULT CHARACTER SET utf8;"


echo "[Cydex] db: create tables for Cydex"
# create tables
mysql -u root -p$PASSWORD -e "use db_zone; source config/sql/db_zone.sql;"

echo "[Cydex] db: create default data for Cydex zone"
# insert default value
mysql -u root -p$PASSWORD -e "source config/sql/init_zone_standalone.sql;"

echo "[Cydex] db: do migrate at last"
sh scripts/migrations/migrate_mysql_zone.sh

exit 0
