#/bin/bash

echo "This script will install or update all Cydex3 services on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if [ $answer != "Y" ]; then
    echo "Abort!"
    exit 0
fi

sh scripts/stop_cydex.sh

systemctl stop firewalld
systemctl disable firewalld

echo -e "\n"
echo "[Cydex] Install system components ... "
yum install -y epel-release

if rpm -q nginx >/dev/null 2>&1; then
    echo "This script will update Nginx services on this host !!!"
    echo -e "Continue Updating Nginx? (Y/n) \c "
    read answer
    if [ $answer == "Y" ]; then
        yum install -y nginx
    fi
else
    yum install -y nginx
fi


if rpm -q redis >/dev/null 2>&1; then
    echo "This script will update Redis services on this host !!!"
    echo -e "Continue Updating Redis? (Y/n) \c "
    read answer
    if [ $answer == "Y" ]; then
        yum install -y redis
    fi
else
    yum install -y redis
fi

#yum install -y python36 python36-devel
yum install -y iptables-services
sh scripts/install_mysql.sh

echo -e "\n"
echo "[Cydex] Install Cydex components ... "
pkgs=`ls cydex_rpms/*.rpm`
for pkg in $pkgs
do
	rpm -Uvh $pkg
done

echo -e "\n"
echo "[Cydex] Config system and Cydex ... "
sh scripts/disable_selinux.sh
sh scripts/config_nginx.sh
sh scripts/config_redis.sh
sh scripts/config_mysql.sh
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh
sh scripts/config_iptables.sh
sh scripts/release.sh

echo -e "\n"
echo "[Cydex] Start Cydex ... "
sh scripts/start_cydex.sh

echo -e "\n"
echo "***********************************"
echo "* Cydex is installed successfully. "
echo "* DON'T FORGET to config 'cydex3-node' and run it !!!" 
echo "***********************************"
echo -e "\n"
echo -e "\n"
