use db_cydex;
DELIMITER ??
DROP PROCEDURE IF EXISTS db_cydex_migrate??
CREATE PROCEDURE db_cydex_migrate()
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'server_config' AND column_name = 'hostname') THEN
        ALTER TABLE `db_cydex`.`server_config` ADD COLUMN hostname varchar(45);
    END IF; 
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user' AND column_name = 'is_complete') THEN
        ALTER TABLE `db_cydex`.`user` ADD COLUMN is_complete int default 1 COMMENT 'Registration completed.1: registration completed 0: registration not completed';
    END IF;
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'project' AND column_name = 'storage_quota') THEN
        ALTER TABLE `db_cydex`.`project` ADD COLUMN storage_quota bigint(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'project_setting_pkg_events' AND column_name = 'name') THEN
        ALTER TABLE `db_cydex`.`project_setting_pkg_events` DROP COLUMN name;
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'company' AND column_name = 'short_name') THEN
        ALTER TABLE `db_cydex`.`company` MODIFY COLUMN short_name varchar(255) DEFAULT null;
    END IF;
    IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = DATABASE() and TABLE_NAME='project_invite_record') THEN
        CREATE TABLE project_invite_record ( id int not null primary key auto_increment,project_id varchar(24) not null,user_id varchar(24) not null,email varchar(50) not null,create_at datetime)ENGINE=InnoDB DEFAULT CHARSET=utf8;
    END IF;
END??
DELIMITER ;

CALL db_cydex_migrate();

use cydex_admin;
alter table auth_user modify column email varchar(254) NOT NULL UNIQUE;


use db_zone;
UPDATE `manage_center` set `url`='https://127.0.0.1:443' where id=1;

use db_statistics;
DELIMITER ??
DROP PROCEDURE IF EXISTS db_statistics_migrate??
CREATE PROCEDURE db_statistics_migrate()
BEGIN
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'cr_overview' AND column_name = 'dt') THEN
        ALTER TABLE `db_statistics`.`cr_overview` MODIFY COLUMN dt varchar(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user_info_dt' AND column_name = 'dt') THEN
        ALTER TABLE `db_statistics`.`user_info_dt` MODIFY COLUMN dt varchar(20) NOT NULL;
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user_info_dt' AND column_name = 'dt2') THEN
        ALTER TABLE `db_statistics`.`user_info_dt` MODIFY COLUMN dt2 varchar(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'cr_data_by_root_user_hour' AND column_name = 'user_id') THEN
        ALTER TABLE `db_statistics`.`cr_data_by_root_user_hour` MODIFY COLUMN user_id varchar(24) DEFAULT NULL;
    END IF;

END??
DELIMITER ;

