-- MySQL dump 10.13  Distrib 5.7.17, for Linux (x86_64)
--
-- Host: localhost    Database: db_zone
-- ------------------------------------------------------
-- Server version	5.7.17-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `auto_scaling_config`
--

DROP TABLE IF EXISTS `auto_scaling_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auto_scaling_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period_sleep` int(11) NOT NULL COMMENT '调整后的间隔期(单位：秒)（如果node发生了增减调整，那这个值就表示在本段时间内调度程序休眠）',
  `period_schedule` int(11) NOT NULL COMMENT '执行node调整的时间间隔(单位：分钟)（即每隔这么长时间才进行node调整）',
  `period_avg` int(11) NOT NULL COMMENT '计算当前负载所需的时间跨度(单位：秒，最大60s)(如果设为5秒，则表示当前的上传速度/下载速度/桶的并发的值是最近5秒的平均值).该选项暂时不用\n',
  `period_idle` int(11) NOT NULL COMMENT '空闲的时间阈值，用来判断node是否空闲，单位：分钟。(比如：该值设为100，则表示如果连续100分钟的上传或下载速度为0，并且磁盘缓存目录为空，则认为该node处于空闲状态，可以被删除。)',
  `max_idle_node_cnt` int(11) NOT NULL COMMENT '需要保留的空闲node的个数(不管如何增减node，系统将保留这么多空闲node)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bucket`
--

DROP TABLE IF EXISTS `bucket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bucket` (
  `id` varchar(50) NOT NULL,
  `enable` tinyint(4) NOT NULL COMMENT '1：有效0：无效，表示是否处于可用状态',
  `forbidden` tinyint(4) NOT NULL COMMENT '是否被禁用 1：是 0：否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `config`
--

DROP TABLE IF EXISTS `config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `content` text,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_bucket_info`
--

DROP TABLE IF EXISTS `log_bucket_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_bucket_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bucket_id` varchar(45) NOT NULL,
  `up_cnt` int(11) DEFAULT NULL COMMENT '上传任务数',
  `down_cnt` int(11) DEFAULT NULL COMMENT '下载任务数',
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_log_node_info_1` (`create_at`,`bucket_id`),
  KEY `idx_log_node_info_2` (`bucket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='每隔一段时间，比如2分钟，记录node当前状态，比如所有任务上传速度之和等';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_node_info`
--

DROP TABLE IF EXISTS `log_node_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_node_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `node_id` varchar(45) NOT NULL,
  `up_rate` bigint(20) DEFAULT '0' COMMENT '当前所有任务上传速度之和，单位：kb/s',
  `down_rate` bigint(20) DEFAULT '0' COMMENT '当前所有任务下载速度之和，单位：kb/s',
  `cache_size` bigint(20) DEFAULT '0' COMMENT '当前所有任务所占用的cache之和,单位:kb',
  `cache_size_all` bigint(20) DEFAULT '0' COMMENT 'node的cache总大小，单位：kb',
  `up_cnt` int(11) DEFAULT NULL COMMENT '上传任务数',
  `down_cnt` int(11) DEFAULT NULL COMMENT '下载任务数',
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_log_node_info_1` (`create_at`,`node_id`),
  KEY `idx_log_node_info_2` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='每隔一段时间，比如2分钟，记录node当前状态，比如所有任务上传速度之和等';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `manage_center`
--

DROP TABLE IF EXISTS `manage_center`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manage_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codename` varchar(32) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codename_UNIQUE` (`codename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `node`
--

DROP TABLE IF EXISTS `node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node` (
  `id` varchar(24) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `addr` varchar(255) DEFAULT NULL,
  `public_ip` varchar(255) DEFAULT NULL,
  `priority` tinyint(4) NOT NULL COMMENT '1:不可删除 0：可以删除',
  `forbidden` tinyint(4) NOT NULL COMMENT '是否被禁用 1：是 0：否',
  `enable` tinyint(4) NOT NULL COMMENT 'true：有效 false：无效，表示该node是否处于可用状态',
  `rx_bandwidth` int(11) NOT NULL COMMENT '最大上传带宽 单位：Mb',
  `tx_bandwidth` int(11) NOT NULL COMMENT '最大下载带宽 单位：Mb',
  `last_login_at` datetime DEFAULT NULL,
  `last_update_at` datetime DEFAULT NULL,
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(100) DEFAULT NULL,
  `interface_addr` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-05-29 15:37:08
