-- MySQL dump 10.13  Distrib 5.7.17, for Linux (x86_64)
--
-- Host: localhost    Database: db_cydex
-- ------------------------------------------------------
-- Server version	5.7.17-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `archive_file`
--

DROP TABLE IF EXISTS `archive_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` varchar(24) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` text NOT NULL,
  `type` int(11) NOT NULL,
  `size` bigint(20) NOT NULL,
  `mode` int(11) DEFAULT '0',
  `path_abs` text,
  `composition` int(11) DEFAULT '0',
  `origin_size` bigint(20) NOT NULL,
  `num_segs` int(11) NOT NULL,
  `seg_avg_size` bigint(20) NOT NULL,
  `storage` varchar(255) DEFAULT NULL,
  `storage_mode` int(11) DEFAULT NULL,
  `encryption_type` int(11) DEFAULT NULL,
  `encryption_block_size` int(11) DEFAULT NULL,
  `digest_method` varchar(32) DEFAULT NULL,
  `digest` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `file_create_at` datetime DEFAULT NULL,
  `file_update_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_file_file_id` (`file_id`),
  KEY `IDX_archive_file_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `archive_filejob`
--

DROP TABLE IF EXISTS `archive_filejob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_filejob` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_job_id` varchar(24) DEFAULT NULL,
  `file_id` varchar(24) NOT NULL,
  `operation` int(11) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `finished_size` bigint(20) NOT NULL DEFAULT '0',
  `state` int(11) NOT NULL DEFAULT '0',
  `segs_state_bitmap` varchar(255) DEFAULT NULL,
  `checked` int(11) NOT NULL DEFAULT '0',
  `finished_times` int(11) DEFAULT NULL,
  `file_job_create_at` datetime DEFAULT NULL,
  `file_job_update_at` datetime DEFAULT NULL,
  `tasks_count` int(11) DEFAULT NULL,
  `max_bitrate` bigint(20) DEFAULT NULL,
  `min_bitrate` bigint(20) DEFAULT NULL,
  `avg_bitrate` bigint(20) DEFAULT NULL,
  `peer_ips` varchar(255) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_filejob_filejob` (`file_id`,`operation`,`user_id`),
  UNIQUE KEY `UQE_archive_filejob_file_job_id` (`file_job_id`),
  KEY `IDX_archive_filejob_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `archive_package`
--

DROP TABLE IF EXISTS `archive_package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_package` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `package_id` varchar(24) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `num_files` int(11) NOT NULL DEFAULT '0',
  `size` bigint(20) NOT NULL DEFAULT '0',
  `origin_size` bigint(20) NOT NULL DEFAULT '0',
  `expires` bigint(20) DEFAULT NULL,
  `expires_after_download` bigint(20) DEFAULT NULL,
  `is_closed` tinyint(1) DEFAULT NULL,
  `is_broken` tinyint(1) DEFAULT NULL,
  `is_deleted` tinyint(1) DEFAULT NULL,
  `is_content_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_downloadable` tinyint(1) DEFAULT NULL,
  `downloadable_at` datetime DEFAULT NULL,
  `deleted_by` varchar(255) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `real_delete_expires` bigint(20) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `package_create_at` datetime DEFAULT NULL,
  `package_update_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_package_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `archive_packagejob`
--

DROP TABLE IF EXISTS `archive_packagejob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_packagejob` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `package_job_id` varchar(24) DEFAULT NULL,
  `package_id` varchar(24) NOT NULL,
  `operation` int(11) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `state` int(11) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `finished_times` int(11) NOT NULL DEFAULT '0',
  `finish_all_at` datetime DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` datetime DEFAULT NULL,
  `is_disable` tinyint(1) DEFAULT '0',
  `disable_by` varchar(24) DEFAULT NULL,
  `disable_at` datetime DEFAULT NULL,
  `package_job_create_at` datetime DEFAULT NULL,
  `package_job_update_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_packagejob_pkgjob` (`package_id`,`operation`,`user_id`),
  UNIQUE KEY `UQE_archive_packagejob_package_job_id` (`package_job_id`),
  KEY `IDX_archive_packagejob_pkgjob2` (`operation`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `company`
--

DROP TABLE IF EXISTS `company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company` (
  `id` varchar(24) NOT NULL,
  `name` varchar(255) NOT NULL,
  `pic_url` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `account_quota` int(11) DEFAULT NULL,
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `storage_quota` bigint(20) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `expired_at` datetime DEFAULT NULL,
  `short_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `company_zone`
--

DROP TABLE IF EXISTS `company_zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_zone` (
  `company_id` varchar(24) NOT NULL,
  `zone_id` varchar(24) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`company_id`,`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `file`
--

DROP TABLE IF EXISTS `file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file` (
  `id` varchar(24) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `size` bigint(11) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `path` text,
  `type` int(11) DEFAULT NULL,
  `mode` int(11) DEFAULT NULL,
  `path_abs` text,
  `composition` int(11) DEFAULT NULL,
  `origin_size` bigint(20) DEFAULT NULL,
  `num_segs` int(11) DEFAULT NULL,
  `seg_avg_size` bigint(20) DEFAULT NULL,
  `storage` varchar(255) DEFAULT NULL,
  `storage_mode` int(11) DEFAULT NULL,
  `encryption_type` int(11) DEFAULT NULL,
  `encryption_block_size` int(11) DEFAULT NULL,
  `digest_method` varchar(32) DEFAULT NULL,
  `digest` varchar(255) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_file_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `file_job`
--

DROP TABLE IF EXISTS `file_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_job` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `file_id` varchar(24) NOT NULL,
  `operation` int(11) NOT NULL COMMENT '1:上传 2：下载',
  `package_id` varchar(24) DEFAULT NULL,
  `state` int(11) DEFAULT NULL COMMENT '0：空闲 1：正在传输 2：完成 3：中断',
  `finished_size` bigint(20) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `segs_state_bitmap` varchar(255) DEFAULT NULL,
  `checked` int(11) DEFAULT NULL,
  `finished_times` int(11) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_file_job_filejob` (`file_id`,`operation`,`user_id`),
  KEY `IDX_file_job_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `js_user_quota_add`
--

DROP TABLE IF EXISTS `js_user_quota_add`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `js_user_quota_add` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dt` datetime DEFAULT NULL COMMENT '结算时间 ',
  `user_id` varchar(24) DEFAULT NULL,
  `data` varchar(2000) DEFAULT NULL COMMENT '结算后数据。json格式，eg：[{ticket_id:"111",traffic:100,start_at:"2018-01-01 12:00:00",end_at:"2018-01-01 12:00:00",type:1,user_id:"001"},{} ...]',
  `available_traffic` bigint(20) DEFAULT NULL COMMENT '结算后可用流量',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='流量余额结算日志表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `language_pkg`
--

DROP TABLE IF EXISTS `language_pkg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `language_pkg` (
  `lan_code` varchar(10) DEFAULT NULL COMMENT 'zh:简体中文 zh-tw:繁体中文 en：英语',
  `key` varchar(30) DEFAULT NULL,
  `value` varchar(50) DEFAULT NULL,
  UNIQUE KEY `idx_language_pkg_1` (`key`,`lan_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='语言包，为了多国语言版';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `license_key`
--

DROP TABLE IF EXISTS `license_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `license_key` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `license_key` varchar(1000) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_file`
--

DROP TABLE IF EXISTS `log_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_file` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1：上传成功 2：下载成功 4：删除成功',
  `state` int(11) DEFAULT NULL COMMENT '0:空闲 1：正在传输 2：成功 ',
  `operation_at` datetime DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL COMMENT '压缩后的size',
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `finish_size` bigint(20) DEFAULT NULL COMMENT '实际完成的size',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_op`
--

DROP TABLE IF EXISTS `log_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_op` (
  `id` varchar(24) NOT NULL,
  `operator_id` varchar(24) DEFAULT NULL COMMENT '操作者id',
  `operator_name` varchar(50) DEFAULT NULL COMMENT '操作者名称',
  `to_user_id` varchar(24) DEFAULT NULL COMMENT '被操作者',
  `to_user_name` varchar(50) DEFAULT NULL,
  `action` int(11) DEFAULT NULL COMMENT '// 1:登录 2：登出 3：创建包裹 4：删除包裹 5：上传 6：下载 7：创建project 8：删除project 9：激活mini app 10:修改project 11:修改project成员 12：修改project的成员权限 13：修改setting 14:修改默认接收者 15：离开project 16:创建group 17：修改分组 18：修改分组成员 19：删除分组 20：邀请用户 21：激活用户 22:管理员踢出用户 23：后台自动\n-1:其他',
  `details` varchar(500) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `operation_at` datetime DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `data` varchar(2000) DEFAULT NULL COMMENT '{"file_id":cxxx,"package_id":ddd}',
  `company_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='登录、登出、创建包裹、上传、等操作日志，\n因为action不同，有些字段可能没有值\n只要用户有动作就记录日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_package`
--

DROP TABLE IF EXISTS `log_package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_package` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1：上传成功 2：下载成功',
  `state` int(11) DEFAULT NULL,
  `operation_at` datetime DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL COMMENT '压缩后的size',
  `user_id_upload` varchar(24) DEFAULT NULL,
  `user_name_upload` varchar(50) DEFAULT NULL,
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `file_cnt` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='操作成功时候才记录该日志';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_task`
--

DROP TABLE IF EXISTS `log_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_task` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `allocated_bitrate` bigint(20) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1:上传 2：下载',
  `state` int(11) DEFAULT NULL COMMENT '0：没有发生传输 2：成功结束 3：中断（发生过传输）',
  `average_bitrate` bigint(20) DEFAULT NULL,
  `peer_ip` varchar(64) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `traffic` bigint(20) DEFAULT NULL,
  `task_id` varchar(24) DEFAULT NULL,
  `task_create_at` datetime DEFAULT NULL COMMENT 'task创建时间',
  `f2tp_backend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_task_hour`
--

DROP TABLE IF EXISTS `log_task_hour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_task_hour` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1:上传 2：下载',
  `allocated_bitrate` bigint(11) DEFAULT NULL,
  `max_bitrate` bigint(11) DEFAULT NULL,
  `min_bitrate` bigint(20) DEFAULT NULL,
  `average_bitrate` bigint(20) DEFAULT NULL,
  `peer_ip` varchar(64) DEFAULT NULL,
  `traffic` bigint(11) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `period` int(11) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `minute_bitrate` varchar(1000) DEFAULT NULL COMMENT '上传或下载期间，每分钟的平均码率。是一个数组json，每个位置表示1分钟平均码率。单位：k\neg. [343,545,66,11,4]',
  `task_id` varchar(24) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `f2tp_backend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mail_server_config`
--

DROP TABLE IF EXISTS `mail_server_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mail_server_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_enable` int(11) DEFAULT NULL COMMENT '0:不启用\n1:启用',
  `contact_name` varchar(100) DEFAULT NULL COMMENT '用户收到mail时看到的联系人名称',
  `description` varchar(100) DEFAULT NULL COMMENT '描述',
  `host` varchar(45) NOT NULL COMMENT '服务器地址',
  `port` int(11) NOT NULL COMMENT '端口',
  `account` varchar(45) NOT NULL COMMENT '账号',
  `password` varchar(45) NOT NULL COMMENT '密码',
  `tls` int(11) DEFAULT NULL COMMENT '0:不启用\n1:启用tls',
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `notification_record`
--

DROP TABLE IF EXISTS `notification_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `send` varchar(255) NOT NULL,
  `receiver` varchar(255) NOT NULL,
  `state` int(11) NOT NULL,
  `details` varchar(255) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package`
--

DROP TABLE IF EXISTS `package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package` (
  `id` varchar(24) NOT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `size` bigint(11) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `num_files` int(11) DEFAULT NULL,
  `origin_size` bigint(20) DEFAULT NULL,
  `expires` bigint(20) DEFAULT NULL,
  `expires_after_download` bigint(20) DEFAULT NULL,
  `is_closed` tinyint(4) DEFAULT NULL,
  `is_broken` tinyint(4) DEFAULT NULL,
  `is_downloadable` tinyint(4) DEFAULT NULL,
  `downloadable_at` datetime DEFAULT NULL,
  `is_deleted` tinyint(4) DEFAULT NULL,
  `deleted_by` varchar(255) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `is_content_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `real_delete_expires` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_package_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package_job`
--

DROP TABLE IF EXISTS `package_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package_job` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1:上传  2：下载',
  `state` int(11) DEFAULT NULL COMMENT '0：空闲 1：正在传输 2：完成 3：中断 100:上传下载都完成',
  `is_read` tinyint(4) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `finished_times` int(11) DEFAULT NULL,
  `finish_all_at` datetime DEFAULT NULL,
  `is_deleted` tinyint(4) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `is_disable` tinyint(4) DEFAULT NULL,
  `disable_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `disable_by` varchar(24) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_package_job_pkgjob` (`package_id`,`operation`,`user_id`),
  KEY `IDX_package_job_pkgjob2` (`operation`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project` (
  `id` varchar(24) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `creater` varchar(24) DEFAULT NULL COMMENT 'project创建者',
  `creater_name` varchar(45) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `pkg_expire` int(11) DEFAULT NULL,
  `pkg_expire_after_download` int(11) DEFAULT NULL,
  `allow_pkg_level_expiration` tinyint(4) DEFAULT NULL,
  `max_seg_num` bigint(20) DEFAULT NULL,
  `min_seg_size` bigint(20) DEFAULT NULL,
  `max_seg_size` bigint(20) DEFAULT NULL,
  `max_upload_bandwidth` bigint(20) DEFAULT NULL,
  `max_download_bandwidth` bigint(20) DEFAULT NULL,
  `save_mode` int(11) DEFAULT NULL COMMENT '保存模式，0:分片保存 1:完整文件',
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `pic_url` varchar(200) DEFAULT NULL,
  `company_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_1` (`create_at`),
  KEY `idx_project_2` (`creater`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_default_notification`
--

DROP TABLE IF EXISTS `project_default_notification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_default_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `settings_id` varchar(24) NOT NULL,
  `mail` varchar(100) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_default_recipients`
--

DROP TABLE IF EXISTS `project_default_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_default_recipients` (
  `user_id` varchar(24) NOT NULL COMMENT '0:project 创建者 1：管理员 2：普通用户',
  `project_id` varchar(24) NOT NULL,
  `create_at` datetime DEFAULT NULL,
  `recipient_id` varchar(24) NOT NULL,
  UNIQUE KEY `idx_project_default_recipient_1` (`user_id`,`project_id`,`recipient_id`),
  KEY `idx_project_default_recipient_2` (`project_id`,`user_id`),
  KEY `idx_project_default_recipient_3` (`recipient_id`,`project_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_group`
--

DROP TABLE IF EXISTS `project_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_group` (
  `id` varchar(24) NOT NULL,
  `group_name` varchar(50) DEFAULT NULL,
  `project_id` varchar(24) NOT NULL COMMENT 'zh:简体中文 zh-tw:繁体中文 en：英语',
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `user_id` varchar(24) DEFAULT NULL COMMENT '创建者id',
  PRIMARY KEY (`id`),
  KEY `idx_project_group_1` (`project_id`,`user_id`),
  KEY `idx_project_group_2` (`user_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_group_member`
--

DROP TABLE IF EXISTS `project_group_member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_group_member` (
  `user_id` varchar(24) NOT NULL,
  `group_id` varchar(24) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_group_member_1` (`group_id`,`user_id`),
  KEY `idx_project_group_member_2` (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_role_permission`
--

DROP TABLE IF EXISTS `project_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_role_permission` (
  `id` varchar(24) NOT NULL,
  `code` varchar(6) NOT NULL,
  `role_id` tinyint(4) NOT NULL,
  `value1` int(11) DEFAULT NULL,
  `value2` int(11) DEFAULT NULL,
  `is_allowed` tinyint(4) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_project_role_detail_2` (`role_id`,`code`),
  KEY `idx_project_role_detail_1` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_setting`
--

DROP TABLE IF EXISTS `project_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_setting` (
  `id` varchar(24) NOT NULL COMMENT '0:project 创建者 1：管理员 2：普通用户',
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `operation` tinyint(4) DEFAULT '2' COMMENT '1.仅上传 2.仅下载 3.Both',
  `upload_max_bps` bigint(20) DEFAULT '0',
  `download_max_bps` bigint(20) DEFAULT '0',
  `is_hide` int(11) DEFAULT NULL COMMENT '1:隐藏(对其他普通用户)\n0:不隐藏',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_setting_pkg_events`
--

DROP TABLE IF EXISTS `project_setting_pkg_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_setting_pkg_events` (
  `id` varchar(24) NOT NULL,
  `code` varchar(50) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `settings_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_setting_pkg_events_1` (`settings_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_setting_pub_methods`
--

DROP TABLE IF EXISTS `project_setting_pub_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_setting_pub_methods` (
  `id` varchar(24) NOT NULL,
  `code` varchar(50) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `settings_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_setting_pub_methods_1` (`settings_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_user`
--

DROP TABLE IF EXISTS `project_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_user` (
  `user_id` varchar(24) NOT NULL,
  `project_id` varchar(24) NOT NULL,
  `role_id` tinyint(4) NOT NULL,
  `settings_id` varchar(24) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_project_user_1` (`project_id`,`user_id`),
  UNIQUE KEY `idx_project_user_2` (`user_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `security_group`
--

DROP TABLE IF EXISTS `security_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `security_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sg_id` varchar(45) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(200) DEFAULT NULL,
  `company_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_security_group_1` (`sg_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `security_group_detail`
--

DROP TABLE IF EXISTS `security_group_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `security_group_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sg_id` varchar(45) NOT NULL,
  `sg_detail` varchar(200) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` int(11) DEFAULT NULL COMMENT '规则类型\n1:设备码\n2:ip\n目前只使用设备码',
  `description` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_security_group_detail_2` (`sg_id`,`sg_detail`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `server_config`
--

DROP TABLE IF EXISTS `server_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `server_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(45) NOT NULL COMMENT '服务端当前版本号 比如：1.0.0',
  `compatibility_s` int(11) NOT NULL COMMENT '兼容指start',
  `compatibility_e` int(11) NOT NULL COMMENT '兼容值end',
  `max_available_traffic` bigint(20) DEFAULT NULL COMMENT '免费用户的最大可用流量，单位：兆',
  `cydex_manager_code` varchar(24) DEFAULT NULL COMMENT '管理中心识别号，用于区分各地管理中心',
  `max_upload_bps` bigint(20) DEFAULT NULL COMMENT '默认的每个人的最大上传带宽，单位 bit/s',
  `max_download_bps` bigint(20) DEFAULT NULL COMMENT '默认的每个人的最大下载带宽，单位 bit/s',
  `project_max_segs_num` int(11) DEFAULT NULL COMMENT '最多分片个数',
  `project_min_seg_size` bigint(20) DEFAULT NULL COMMENT '最小分片字节',
  `project_max_seg_size` bigint(20) DEFAULT NULL COMMENT '最大分片字节',
  `calcu_traffic_interval` int(11) DEFAULT NULL COMMENT '实时计算用户流量余额的时间间隔，单位：分钟',
  `package_expire` int(11) DEFAULT NULL COMMENT '包裹过期时间，单位：秒',
  `package_delete_expire` int(11) DEFAULT NULL COMMENT '包裹被删除后多久包裹记录被删除，单位：天，默认15天',
  `system_start_dt` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '系统正式运营时间。所有结算，报表的初始时间都根据这个值为准。小于这个时间的数据都不作为正式数据。',
  `overdraw_n` decimal(5,2) DEFAULT NULL COMMENT '可透支流量系数\n可透支流量=（注册时长*0.2+购买流量总量*0.8）*n',
  `size_n` decimal(5,2) DEFAULT NULL COMMENT '可用存储空间系数\n可用存储空间 = 剩余流量*n',
  `security_group` int(11) DEFAULT NULL COMMENT '是否启用安全组\n1:启用\n0:不启用',
  `server_name` varchar(100) DEFAULT NULL COMMENT '服务器名称',
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `hostname` varchar(100) DEFAULT NULL,
  `system_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task`
--

DROP TABLE IF EXISTS `task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `allocated_bitrate` bigint(11) DEFAULT NULL,
  `max_bitrate` bigint(11) DEFAULT NULL,
  `min_bitrate` bigint(11) DEFAULT NULL,
  `peer_ip` varchar(64) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `total_traffic` bigint(20) DEFAULT NULL,
  `total_bytes` bigint(20) DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `avg_bitrate` bigint(20) DEFAULT NULL,
  `f2tp_backend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_task_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `user_id` varchar(24) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `time_zone` tinyint(4) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `mobile_phone` varchar(45) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `product_code` varchar(3) DEFAULT NULL COMMENT '1:从cydex注册 2：其他地方注册的用户',
  `pic_url` varchar(100) DEFAULT '',
  `account` varchar(45) DEFAULT NULL COMMENT '用户账号，唯一',
  `role` int(11) DEFAULT '0' COMMENT '0:普通用户\n1:限制用户(不能创建workspace)',
  `sg_id` varchar(45) DEFAULT NULL COMMENT '安全组id',
  `password` varchar(45) NOT NULL,
  `is_complete` int(11) DEFAULT '1' COMMENT '是否完成注册标志 1:已完成注册 0:未完成注册',
  `company_id` varchar(24) NOT NULL,
  `company_role` int(11) DEFAULT NULL COMMENT '用户在company中的角色 0:普通用户 1:高级用户(可创建工作区) 2:manager(可创建工作区) 3:admin(可创建工作区)',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_user_1` (`email`),
  UNIQUE KEY `idx_user_2` (`account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_login`
--

DROP TABLE IF EXISTS `user_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_login` (
  `user_id` varchar(24) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `time_zone` tinyint(4) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `os_type` varchar(20) DEFAULT NULL,
  `os_detail` varchar(100) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL COMMENT '上次登陆时间',
  `state` tinyint(4) DEFAULT NULL COMMENT 'mini app状态 1：在线 0：离线',
  PRIMARY KEY (`user_id`),
  KEY `idx_user_1` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_role_permission`
--

DROP TABLE IF EXISTS `user_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_role_permission` (
  `id` varchar(24) NOT NULL,
  `code` varchar(6) NOT NULL,
  `role_id` tinyint(4) NOT NULL,
  `value1` int(11) DEFAULT NULL,
  `value2` int(11) DEFAULT NULL,
  `is_allowed` tinyint(4) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `description` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_user_role_permission_2` (`role_id`,`code`),
  KEY `idx_user_role_permission_1` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `yw_black_list`
--

DROP TABLE IF EXISTS `yw_black_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `yw_black_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(24) NOT NULL COMMENT '用户id',
  `operate_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `operate_id` varchar(24) DEFAULT NULL COMMENT '操作者id(指运维操作者id，不是用户id)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_yw_black_list_1` (`user_id`),
  KEY `idx_yw_black_list_2` (`operate_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='yw开头的表是指给运维用的\n';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_invite_record`
--

DROP TABLE IF EXISTS `project_invite_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_invite_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(24) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `email` varchar(50) NOT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `zone`
--

DROP TABLE IF EXISTS `zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `zone` (
  `id` varchar(24) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `host` varchar(50) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  `secret_key` varchar(50) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint(1) DEFAULT '0' COMMENT '数据中心类型：\n0:公有\n1:私有\n2:特殊用途',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_zone_3` (`id`),
  UNIQUE KEY `idx_zone_5` (`host`),
  KEY `idx_zone_1` (`host`),
  KEY `idx_zone_2` (`secret_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-05-29 15:35:10
