use db_cydex;
DELIMITER ??
DROP PROCEDURE IF EXISTS db_cydex_migrate??
CREATE PROCEDURE db_cydex_migrate()
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'server_config' AND column_name = 'hostname') THEN
        ALTER TABLE `db_cydex`.`server_config` ADD COLUMN hostname varchar(45);
    END IF; 
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user' AND column_name = 'is_complete') THEN
        ALTER TABLE `db_cydex`.`user` ADD COLUMN is_complete int default 1 COMMENT 'Registration completed.1: registration completed 0: registration not completed';
    END IF;
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'project' AND column_name = 'storage_quota') THEN
        ALTER TABLE `db_cydex`.`project` ADD COLUMN storage_quota bigint(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'project_setting_pkg_events' AND column_name = 'name') THEN
        ALTER TABLE `db_cydex`.`project_setting_pkg_events` DROP COLUMN name;
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'company' AND column_name = 'short_name') THEN
        ALTER TABLE `db_cydex`.`company` MODIFY COLUMN short_name varchar(255) DEFAULT null;
    END IF;
    IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = DATABASE() and TABLE_NAME='project_invite_record') THEN
        CREATE TABLE project_invite_record ( id int not null primary key auto_increment,project_id varchar(24) not null,user_id varchar(24) not null,email varchar(50) not null,create_at datetime)ENGINE=InnoDB DEFAULT CHARSET=utf8;
    END IF;
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'package_job' AND column_name = 'save_mode') THEN
        ALTER TABLE `db_cydex`.`package_job` ADD COLUMN save_mode int(11) DEFAULT NULL;
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.tables where table_schema = DATABASE() AND table_name = 'storage_file') THEN
        CREATE TABLE `storage_file` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `file_id` varchar(24) DEFAULT NULL,
          `path` text,
          `size` bigint(11) DEFAULT NULL,
          `user_id` varchar(24) DEFAULT NULL,
          `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
          `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          `deleted_at` datetime DEFAULT NULL,
          PRIMARY KEY (`id`),
          KEY `IDX_stored_file` (`file_id`),
          KEY `IDX_user` (`user_id`),
          CONSTRAINT `IDX_stored_file` FOREIGN KEY (`file_id`) REFERENCES `file` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
          CONSTRAINT `IDX_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`user_id`) ON DELETE NO ACTION ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.tables where table_schema = DATABASE() AND table_name = 'permissions') THEN
        CREATE TABLE `permissions` (
          `id` varchar(6) NOT NULL AUTO_INCREMENT,
          `name` varchar(60) DEFAULT NULL,
          PRIMARY KEY (`id`),
          UNIQUE KEY `UNIQUE` (`name`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
        INSERT INTO `permissions` (`id`, `name`)
        VALUES
          ('001012','Archive'),
          ('001010','Check other people package information'),
          ('001001','Create package'),
          ('001002','Dealete/upadate other people packages'),
          ('001004','Delete members'),
          ('001008','Delete project'),
          ('001003','Invite members'),
          ('001009','Modify the basic information of the project'),
          ('001013','Retrieve'),
          ('001007','Set settings for other users'),
          ('001005','View preoject basic information'),
          ('001006','View project statistics'),
          ('001011','View the project log');
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.tables where table_schema = DATABASE() AND table_name = 'roles') THEN
        CREATE TABLE `roles` (
          `id` int(4) NOT NULL AUTO_INCREMENT,
          `name` varchar(60) DEFAULT NULL,
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
        INSERT INTO `roles` (`id`, `name`)
        VALUES
          (0,'Company admin'),
          (1,'Workspace owner'),
          (2,'General user');
    END IF;

    IF NOT EXISTS (SELECT * FROM information_schema.tables where table_schema = DATABASE() AND table_name = 'user_project_permissions') THEN
        CREATE TABLE `user_project_permissions` (
          `id` bigint(11) NOT NULL AUTO_INCREMENT,
          `user_id` varchar(24) DEFAULT NULL,
          `project_id` varchar(24) DEFAULT NULL,
          `role_id` int(4) DEFAULT NULL,
          `permission_id` varchar(6) DEFAULT NULL,
          `is_allowed` tinyint(4) DEFAULT '1',
          `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
          `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (`id`),
          UNIQUE KEY `user_project_role_permission` (`user_id`,`project_id`,`role_id`,`permission_id`),
          KEY `FK_Permissions_User_project_permissions` (`permission_id`),
          KEY `FK_Project_User_project_permissions` (`project_id`),
          KEY `FK_Roles_User_project_permissions` (`role_id`),
          CONSTRAINT `FK_Permissions_User_project_permissions` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
          CONSTRAINT `FK_Project_User_project_permissions` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
          CONSTRAINT `FK_Roles_User_project_permissions` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
          CONSTRAINT `FK_User_User_project_permissions` FOREIGN KEY (`user_id`) REFERENCES `user` (`user_id`) ON DELETE NO ACTION ON UPDATE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    END IF;
END??
DELIMITER ;

CALL db_cydex_migrate();

use cydex_admin;
alter table auth_user modify column email varchar(254) NOT NULL UNIQUE;


use db_zone;
UPDATE `manage_center` set `url`='https://127.0.0.1:443' where id=1;

use db_statistics;
DELIMITER ??
DROP PROCEDURE IF EXISTS db_statistics_migrate??
CREATE PROCEDURE db_statistics_migrate()
BEGIN
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'cr_overview' AND column_name = 'dt') THEN
        ALTER TABLE `db_statistics`.`cr_overview` MODIFY COLUMN dt varchar(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user_info_dt' AND column_name = 'dt') THEN
        ALTER TABLE `db_statistics`.`user_info_dt` MODIFY COLUMN dt varchar(20) NOT NULL;
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user_info_dt' AND column_name = 'dt2') THEN
        ALTER TABLE `db_statistics`.`user_info_dt` MODIFY COLUMN dt2 varchar(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'cr_data_by_root_user_hour' AND column_name = 'user_id') THEN
        ALTER TABLE `db_statistics`.`cr_data_by_root_user_hour` MODIFY COLUMN user_id varchar(24) DEFAULT NULL;
    END IF;

END??
DELIMITER ;

