#!/bin/sh

echo "Installing RabbitMQ"

has_rabbitmq=`rpm -qa |grep rabbitmq-server`
if [ ! -z "${has_rabbitmq}" ]; then
    echo "RabbitMQ is installed, no need to install it again."
    exit
fi

#install rabbitmq/erlang Dependencies
yum install -y socat logrotate

# Install mongodb from RPMs
rpm -Uvh rpms/erlang-23.3.4.11-1.el7.x86_64.rpm
rpm -Uvh rpms/rabbitmq-server-3.9.14-1.el7.noarch.rpm

systemctl start rabbitmq-server

# enable service to restart on boot
systemctl enable rabbitmq-server

# create user and password inside script
sh scripts/config_rabbitmq.sh
