#!/bin/sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -m [mode]    Start Cydex server with target mode (combination of 'all, central, zone, node' and 'archive', e.g. 'all-archive')"
    echo "    -e [1/0]     Indicate if current installation is using external resources, 1 for yes"
}

start_central=false
start_zone=false
start_node=false
start_archive=false
unset with_external_resources
while getopts 'm:e:' OPTION; do
    case "$OPTION" in
        m)
            case "${OPTARG}" in
                all*)
                    start_central=true
                    start_zone=true
                    start_node=true
                    ;;
                central*)
                    start_central=true
                    ;;
                zone*)
                    start_zone=true
                    start_node=true
                    ;;
                node*)
                    start_node=true
                    ;;
                archive)
                    ;;
                *)
                    show_help
                    exit 1
                    ;;
            esac
            case "${OPTARG}" in
                *archive)
                    start_archive=true
                    ;;
            esac
            ;;
        e)
            with_external_resources="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

include_svcs=()
if $start_central; then
    include_svcs+=("cydex3-admin" "cydex3-company" "cydex3-manager" "cydex3-transfer" "cydex3-data" "cydex3-notification")
fi
if $start_zone; then
    include_svcs+=("cydex3-zone")
fi
if $start_node; then
    manually_start_node=false
    if [ "$with_external_resources" == "1" ]; then
        echo -e "\nIt is found that you are installing with external resources (DB, Redis, etc).\nYou should NOT start node service now if you are setting up a backup node service. On that case, you will need to at first copy the /opt/caton/cydex3/node/config.ini of the original node server here and then manually start node service."
        read -e -p "* Start node service now anyway? (y/N) " answer
        if [ "$answer" != "y" ] && [ "$answer" != "Y" ]; then
            manually_start_node=true
        fi
    fi
    if ! $manually_start_node; then
        include_svcs+=("cydex3-node")
    fi
fi
if $start_archive; then
    include_svcs+=("cydex3-archive-producer" "cydex3-archive-consumer")
fi

if [ -z $include_svcs ]; then
    echo "[Cydex] No cydex services to start, exit"
    exit
fi

echo "[Cydex] Start cydex services:" "${include_svcs[@]}"

start_cmd=("systemctl start" ${include_svcs[@]})
eval "${start_cmd[@]}"
enable_cmd=("systemctl enable" ${include_svcs[@]})
eval "${enable_cmd[@]}"

# systemctl start cydex3-s3config >/dev/null 2>&1
# systemctl enable cydex3-s3config
