#!/bin/sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -a [1/0]              Indicate if set with archive, yes if ARG equals to 1"
}

unset with_archive
while getopts 'a:' OPTION; do
    case "$OPTION" in
        a)
            with_archive="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

source scripts/resource_funcs.sh

echo -e "\n\n"
echo "[Cydex] Start Cydex Migrations... "

if [ -f "config/sql/migrations/migrate_cydex.sql" ]; then
    run_mysql_script "source config/sql/migrations/migrate_cydex.sql"
fi

if [ "$with_archive" != "1" ]; then
    with_archive=0
fi
echo -e "[Cydex] Setting mysql server config field with_archive as $with_archive.\n"
run_mysql_script "UPDATE db_cydex.server_config SET with_archive = $with_archive"

echo -e "\n\n"
echo "[Cydex] Cydex Migrations Completed!!"
echo -e "\n\n"
