#!/bin/sh
show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -a [1/0]              Indicate if set with archive, yes if ARG equals to 1"
    echo "    -z [1/0]              Indicate if initialising database of zone, yes if ARG equals to 1"
}

unset with_archive
with_zone="1"
while getopts 'a:z:' OPTION; do
    case "$OPTION" in
        a)
            with_archive="$OPTARG"
            ;;
        z)
            with_zone="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo -e "\n\n"
echo "[Cydex] Start Cydex Database Migrations... "

sh scripts/migrations/migrate_mysql_cydex.sh -a "$with_archive"
sh scripts/migrations/migrate_mysql_admin.sh
if [ "$with_zone" == "1" ]; then
    sh scripts/migrations/migrate_mysql_zone.sh
fi
sh scripts/migrations/migrate_mysql_statistics.sh

echo -e "\n\n"
echo "[Cydex] Cydex Database Migrations Completed!!"
echo -e "\n\n"
