#!/bin/sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -e [1/0]              Indicate if using external MySQL server, yes if ARG equals to 1"
}

unset external_mysql
while getopts 'e:' OPTION; do
    case "$OPTION" in
        e)
            external_mysql="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

source scripts/resource_funcs.sh
check_need_install_local_mysql_server $external_mysql
client_only=$(( ! $? ))

if [ $client_only -eq 0 ]; then
    echo "Install mysql client"
    if [ $(rpm -qa | grep mysql-community-client | wc -l) -eq 1 ]; then
        echo "Mysql Client is installed, no need to install again."
        exit
    fi
else
    echo "Install mysql server"
    if has_local_mysql_server; then
        echo "Mysql is installed, no need to install again."
        exit
    fi
fi

if [ ! -d ./rpms ]; then
    echo "There is no rpms found, please contact to the Cydex support."
    exit 1
fi

yum -y remove mariadb-libs*

yum -y localinstall ./rpms/mysql-community-common-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-libs-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-libs-compat-5.7.17-1.el7.x86_64.rpm
yum -y localinstall ./rpms/mysql-community-client-5.7.17-1.el7.x86_64.rpm

if [ $client_only -eq 0 ]; then
    exit
fi

if [ ! -f ./rpms/mysql-community-server-5.7.17-1.el7.x86_64.rpm ]; then
    echo "There is no mysql rpms found, please contact to the Cydex support."
    exit 1
fi

yum -y localinstall ./rpms/mysql-community-server-5.7.17-1.el7.x86_64.rpm
