#!/bin/sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -e [1/0]              Indicate if using external MongoDB, yes if ARG equals to 1"
}

unset external_mongo
while getopts 'e:' OPTION; do
    case "$OPTION" in
        e)
            external_mongo="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

source scripts/resource_funcs.sh
check_need_install_local_mongo_server $external_mongo
client_only=$(( ! $? ))

echo "Install MongoDB"

if [ $client_only -eq 0 ]; then
    if [ $(rpm -qa | grep mongodb-mongosh | wc -l) -eq 1 ]; then
        echo "MongoSH is installed, no need to install again."
        exit
    fi

    rpm -Uvh rpms/mongodb-mongosh-1.1.9.el7.x86_64.rpm
    exit
fi

yum install -y cyrus-sasl cyrus-sasl-gssapi cyrus-sasl-plain

# Install mongodb from RPMs
rpm -Uvh rpms/mongodb-org-database-tools-extra-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-mongosh-1.1.9.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-mongos-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-server-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-shell-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-database-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-database-tools-100.5.1.x86_64.rpm
rpm -Uvh rpms/mongodb-org-tools-5.0.5-1.el7.x86_64.rpm
rpm -Uvh rpms/mongodb-org-5.0.5-1.el7.x86_64.rpm

systemctl start mongod

# enable service to restart on boot
systemctl enable mongod

# create user and password
# Default username & password is in config/mongodb/create-user.js
sh scripts/config_mongodb.sh
