#!/bin/bash

source scripts/resource_funcs.sh
load_cust_mysql_vars

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -p password           Custom MySQL Password"
    echo "    -e [1/0]              Indicate if using external MySQL server, yes if ARG equals to 1"
}

unset external_mysql
while getopts 'p:e:' OPTION; do
    case "$OPTION" in
        p)
            custom_passwd="$OPTARG"
            ;;
        e)
            external_mysql="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo "[Cydex] Initial mysql for Zone"

if [ "$external_mysql" == "1" ]; then
    set_cust_mysql
fi

if mysql_db_exists 'db_zone'; then
    echo "Mysql is initialed for cydex zone, do the migratation."
    sh scripts/migrations/migrate_mysql_zone.sh
    exit
fi

if [ "$external_mysql" != "1" ]; then
    reset_local_mysql_password
fi

echo "[Cydex] db: create databases for Cydex zone"
# create databases
run_mysql_script "CREATE DATABASE db_zone DEFAULT CHARACTER SET utf8;"


echo "[Cydex] db: create tables for Cydex"
# create tables
run_mysql_script "use db_zone; source config/sql/db_zone.sql;"

echo "[Cydex] db: create default data for Cydex zone"
# insert default value
run_mysql_script "source config/sql/init_zone_standalone.sql;"

echo "[Cydex] db: do migrate at last"
sh scripts/migrations/migrate_mysql_zone.sh

exit 0
