#!/bin/sh

source scripts/resource_funcs.sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -e [1/0]              Indicate if using external MongoDB, yes if ARG equals to 1"
}

unset external_mongo
while getopts 'e:' OPTION; do
    case "$OPTION" in
        e)
            external_mongo="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo "[Cydex] Enable Archive in Zone..."

sed -i 's/; mongo_dbname="cydex"/mongo_dbname="cydex"/g' /opt/caton/cydex3/zone/config.ini
sed -i 's/; collection="archive"/collection="archive"/g' /opt/caton/cydex3/zone/config.ini
sed -i 's/; uri="mongodb:\/\/localhost"/uri="mongodb:\/\/localhost"/g' /opt/caton/cydex3/zone/config.ini
sed -i 's/; timeout=30/timeout=30/g' /opt/caton/cydex3/zone/config.ini
sed -i 's/; use_mongo=true/use_mongo=true/g' /opt/caton/cydex3/zone/config.ini
sed -i 's/; username=caton/username=caton/g' /opt/caton/cydex3/zone/config.ini
sed -i 's/; password=Caton_123/password=Caton_123/g' /opt/caton/cydex3/zone/config.ini

if [ "$external_mongo" == "1" ]; then
    set_cust_mongo
fi
