#!/bin/sh

source scripts/resource_funcs.sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -e [1/0]              Indicate if using external Redis, yes if ARG equals to 1"
}

unset external_redis
while getopts 'e:' OPTION; do
    case "$OPTION" in
        e)
            external_redis="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo "[Cydex] Config redis"

if [ "$external_redis" == "1" ]; then
    set_cust_redis
else

    kill -9 `pgrep redis-server` >/dev/null 2>&1
    systemctl stop redis

    if [ ! -f /etc/redis.conf.backup ]; then
        mv /etc/redis.conf /etc/redis.conf.backup
    fi
    cp -r config/redis.conf /etc/redis.conf
    chown redis.root /etc/redis.conf

    systemctl enable redis
    systemctl start redis

fi
