#!/bin/sh

source scripts/resource_funcs.sh
load_cust_mysql_vars

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -p password           Custom MySQL Password"
    echo "    -e [1/0]              Indicate if using external MySQL server, yes if ARG equals to 1"
    echo "    -a [1/0]              Indicate if set with archive, yes if ARG equals to 1"
    echo "    -z [1/0]              Indicate if initialising database of zone, yes if ARG equals to 1"
}

unset external_mysql
unset with_archive
with_zone="1"
while getopts 'p:e:a:z:' OPTION; do
    case "$OPTION" in
        p)
            custom_passwd="$OPTARG"
            ;;
        e)
            external_mysql="$OPTARG"
            ;;
        a)
            with_archive="$OPTARG"
            ;;
        z)
            with_zone="$OPTARG"
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo "[Cydex] Initial mysql"

if [ "$external_mysql" == "1" ]; then
    set_cust_mysql

    if mysql_db_exists 'db_cydex'; then
        echo "Mysql is initialed for cydex, do the migratation."
        sh scripts/migrate_mysql.sh -a "$with_archive" -z "$with_zone"
        exit
    fi
else

    # make sure MySQL is using UTC time-zone
    tz=`sed -n '/^default-time_zone/p' /etc/my.cnf`
    if [ -z "$tz" ]; then
        sed -i '$a\default-time_zone = +0:00' /etc/my.cnf
    fi

    if mysql_db_exists 'db_cydex'; then
        echo "Mysql is initialed for cydex, do the migratation."
        sed -i '/^default-time_zone/c\default-time_zone = +0:00' /etc/my.cnf
        systemctl restart mysqld
        sleep 1
        sh scripts/migrate_mysql.sh -a "$with_archive" -z "$with_zone"
        exit
    fi

    reset_local_mysql_password
fi

echo "[Cydex] db: create databases for Cydex"
# create databases
run_mysql_script "CREATE DATABASE db_cydex DEFAULT CHARACTER SET utf8;"
if [ "$with_zone" == "1" ]; then
    run_mysql_script "CREATE DATABASE db_zone DEFAULT CHARACTER SET utf8;"
fi
run_mysql_script "CREATE DATABASE db_statistics DEFAULT CHARACTER SET utf8;"
run_mysql_script "CREATE DATABASE cydex_admin DEFAULT CHARACTER SET utf8;"


echo "[Cydex] db: create tables for Cydex"
# create tables
run_mysql_script "use db_cydex; source config/sql/db_cydex.sql;"
if [ "$with_zone" == "1" ]; then
    run_mysql_script "use db_zone; source config/sql/db_zone.sql;"
fi
run_mysql_script "use db_statistics; source config/sql/db_statistics.sql;"
run_mysql_script "use cydex_admin; source config/sql/cydex_admin.sql;"

echo "[Cydex] db: create default data for Cydex"
# insert default value
if [ "$with_zone" == "1" ]; then
    run_mysql_script "source config/sql/init_cydex.sql;"
    run_mysql_script "source config/sql/init_zone.sql;"
else
    run_mysql_script "source config/sql/init_cydex_standalone.sql;"
fi
run_mysql_script "source config/sql/init_statistics.sql;"


# echo "[Cydex] db: execute admin service migrate"
# # migration
# cd /opt/caton/cydex3/admin
# /opt/caton/cydex3/pyvenv/bin/python manage.py migrate

echo "[Cydex] db: do migrate at last"
sh scripts/migrate_mysql.sh -a "$with_archive" -z "$with_zone"

exit 0
