#!/bin/sh
LDAP_CONFIG_FILE=/opt/caton/cydex3/ad_domain/profile.ini
LDAP_CONFIG_FILE_BAK=${LDAP_CONFIG_FILE}.bak

echo -e "\n"
echo "Configuring Microsoft Active Directory login via LDAP protocol.
After this script creates config file $LDAP_CONFIG_FILE and restarts related Cydex services, Cydex logins will authenticate against LDAP server."

if [ -f "$LDAP_CONFIG_FILE" ]; then
    echo -e "\nExisting config file found.\nWould you like to overwrite it with new parameters?"
    while [ "$confirm_config_ldap" != "n" ] && [ "$confirm_config_ldap" != "y" ] ; do
        echo -e "Proceed? (y/n) : \c "
        read confirm_config_ldap
    done
    if [ "$confirm_config_ldap" == "n" ]; then
        echo "Skip configuration of LDAP login. Exiting script..."
        exit 0
    fi
fi

echo -e "\nInput LDAP Server url with protocol scheme, address and port number, e.g. ldap://ds.example.com:389 OR ldaps://ds.example.com:636"
while [ -z "$ldap_url" ]; do
    echo -e "LDAP url: \c "
    read ldap_url
done

echo -e "\nNote: If ldaps:// is used, please place the Root CA certificate to directory /etc/pki/ca-trust/source/anchors"
echo -e "Then run the following command afterwards: update-ca-trust\n"
echo "The certificate can be a DER encoded or Base-64 encoded .cer file."
echo "Note that if the certificate signature uses an insecure algorithm such as SHA1, connection to LDAP Server may be refused during user login."
echo "In such case, please upgrade to a secure signing algorithm."

echo -e "\nChoose whether to skip verifying LDAP Server Certificate when ldaps:// is used. Not recommended."
ldap_insecure_skip_verify="false"
while [ "$ldap_insecure_answer" != "n" ] && [ "$ldap_insecure_answer" != "y" ] ; do
    echo -e "InsecureSkipVerify? (n/y) : \c "
    read ldap_insecure_answer
done
if [ "$ldap_insecure_answer" == "y" ]; then
    ldap_insecure_skip_verify="true"
fi

echo -e "\nInput Base DN, e.g. dc=ds,dc=example,dc=com\nPlease ensure all AD users can be searched under this DN."
while [ -z "$ldap_base_dn" ]; do
    echo -e "Base DN: \c "
    read ldap_base_dn
done

# Backup config file
if [ -f "$LDAP_CONFIG_FILE" ]; then
    echo -e "\nExisting config file found. Backing up to file $LDAP_CONFIG_FILE_BAK\n"
    mv "$LDAP_CONFIG_FILE" "$LDAP_CONFIG_FILE_BAK"
fi

# Create parent directories and config file
install -D /dev/null "$LDAP_CONFIG_FILE"

cat <<EOF >"$LDAP_CONFIG_FILE"
[AD]
ldap_url = ${ldap_url}
base_dn = "${ldap_base_dn}"
insecure_skip_verify = ${ldap_insecure_skip_verify}
EOF

echo "LDAP configuration saved to $LDAP_CONFIG_FILE
Restarting Cydex services..."

systemctl restart cydex3-admin
systemctl restart cydex3-company
systemctl restart cydex3-manager