#/bin/bash

source scripts/resource_funcs.sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -a, --with-archive    Install Cydex with Archive Mode"
    echo "    --external-rabbitmq   Install Cydex with external RabbitMQ server"
}

unset with_archive
unset external_rabbitmq
has_external_res=0
while getopts 'a-:' OPTION; do
    case "$OPTION" in
        a)
            with_archive=1
            ;;
        -)
            case "${OPTARG}" in
                with-archive)
                    with_archive=1
                    ;;
                external-rabbitmq)
                    external_rabbitmq=1
                    has_external_res=1
                    ;;
                *)
                    show_help
                    exit 1
                    ;;
            esac
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.4.2\n\n\n"

echo "This script will install or upgrade Cydex3-node service standalone on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

echo -e "\n"
echo "[Cydex] Stop Node ... "
sh scripts/stop_cydex.sh

echo -e "\n"
echo "[Cydex] Install system components ... "
yum update -y --exclude=mongodb*
yum install -y epel-release
yum install -y iptables-services
if [ "$with_archive" == "1" ]; then
    # Install AWS CLI
    sh scripts/install_aws_cli.sh

    # install RabbitMQ
    sh scripts/install_rabbitmq.sh
fi

echo -e "\n"
echo "[Cydex] Install Cydex node components ... "
pkgs=`ls cydex_rpms/*node*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done

if [ "$with_archive" == "1" ]; then
    echo -e "\n"
    echo "[Cydex] Install Cydex Archive components ... "
    pkgs=`ls cydex_archive_rpms/*.rpm`
    for pkg in $pkgs
    do
        rpm -Uvh --force $pkg
    done
fi

echo -e "\n"
echo "[Cydex] Config system and Cydex node ... "
sh scripts/disable_selinux.sh
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh

if [ "$with_archive" == "1" ]; then
    sh scripts/config_node.sh -a
    sh scripts/config_archive.sh -e "$external_rabbitmq"
else
    sh scripts/config_node.sh
fi

start_mode="node"
if [ "$with_archive" == "1" ]; then
    start_mode="$start_mode-archive"
fi
sh scripts/start_cydex.sh -m "$start_mode" -e "$has_external_res"

echo -e "\n"
echo "***********************************"
echo "* Cydex node is installed successfully. "
echo "***********************************"
echo -e "\n"
echo -e "\n"
