#/bin/bash

yum update -y --exclude=mongodb*

systemctl stop firewalld
systemctl disable firewalld
yum install -y iptables-services

yum install -y epel-release unzip

### Redis ###

yum install -y redis
sh scripts/config_redis.sh

sed -i "s/bind 127.0.0.1/bind 0.0.0.0/g" /etc/redis.conf
systemctl restart redis

### Redis end ###

### MySQL ###

sh scripts/install_mysql.sh

if [ ! -f /etc/my.cnf.backup ]; then
    mv /etc/my.cnf /etc/my.cnf.backup
fi

cp -r config/my.cnf /etc/my.cnf
mv /var/log/mysqld.log /var/log/mysqld.log.backup >/dev/null 2>&1

echo -e "bind-address=0.0.0.0\n" >> /etc/my.cnf

systemctl enable mysqld
systemctl start mysqld

sleep 5

PASSWORD="Caton_123"
orig_password=`cat /var/log/mysqld.log | grep "A temporary password" | awk -F "root@localhost: " '{print $2}'`
mysqladmin -u root -p${orig_password} password $PASSWORD >/dev/null 2>&1

mysql -u root -p$PASSWORD -e "grant all privileges on *.* to 'root'@'%' identified by '$PASSWORD';"
mysql -u root -p$PASSWORD -e "flush privileges;"

### MySQL end ###

### MongoDB ###
sh scripts/install_mongodb.sh
sed -i "s/bindIp: 127.0.0.1/bindIp: 0.0.0.0/g" /etc/mongod.conf
systemctl restart mongod

### MongoDB end ###

### RabbitMQ ###
sh scripts/install_rabbitmq.sh
# sh scripts/enable_rabbitmq_ui.sh 
### RabbitMQ end ###

### Config iptables ###
iptables -I INPUT -p tcp -m tcp --dport 3306 -j ACCEPT
iptables -I INPUT -p tcp -m tcp --dport 6379 -j ACCEPT
iptables -I INPUT -p tcp -m tcp --dport 27017 -j ACCEPT
iptables -I INPUT -p tcp -m tcp --dport 5672 -j ACCEPT
service iptables save
### Config iptables end ###
