#/bin/bash

source scripts/resource_funcs.sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -a, --with-archive    Install Cydex with Archive Mode"
    echo "    -l, --with-ldap       Install Cydex with LDAP Authentication"
    echo "    --external-mysql      Install Cydex with external MySQL database"
    echo "    --external-redis      Install Cydex with external Redis"
}

unset with_ldap
unset with_archive
unset external_mysql
unset external_redis
while getopts 'al-:' OPTION; do
    case "$OPTION" in
        a)
            with_archive=1
            ;;
        l)
            with_ldap=1
            ;;
        -)
            case "${OPTARG}" in
                with-archive)
                    with_archive=1
                    ;;
                with-ldap)
                    with_ldap=1
                    ;;
                external-mysql)
                    external_mysql=1
                    ;;
                external-redis)
                    external_redis=1
                    ;;
                *)
                    show_help
                    exit 1
                    ;;
            esac
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done

echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.4.2\n\n\n"

echo "This script will install or update all Cydex3 central services including cydex3-admin, cydex3-company, cydex3-manager, cydex3-transfer on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

sh scripts/stop_cydex.sh

systemctl stop firewalld
systemctl disable firewalld

echo -e "\n"
echo "[Cydex] Install system components ... "
yum update -y --exclude=mongodb*
yum install -y epel-release unzip

if rpm -q nginx >/dev/null 2>&1; then
    echo "This script will Reinstall Nginx services on this host !!!"
    echo -e "Continue Reinstalling Nginx? (Y/n) \c "
    read answer
    if ([ $answer == "Y" ] || [ $answer == "y" ]); then
        systemctl stop nginx
        yum remove -y nginx
        yum install -y nginx
    fi
else
    yum install -y nginx
fi

yum install -y redis
sh scripts/install_mysql.sh -e "$external_mysql"
yum install -y iptables-services

echo -e "\n"
echo "[Cydex] Install Cydex components ... "
pkgs=`ls cydex_rpms/*.rpm | grep -v -E '.*(node|zone).*'`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done

echo -e "\n"
echo "[Cydex] Config system and Cydex ... "
sh scripts/disable_selinux.sh
sh scripts/config_nginx.sh
sh scripts/config_redis.sh -e "$external_redis" || exit $?
sh scripts/config_mysql.sh -z "0" -a "$with_archive" -e "$external_mysql" || exit $?
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh
sh scripts/config_iptables.sh

sh scripts/release.sh

echo -e "\n"
echo "[Cydex] Start Cydex Central Controller... "

sh scripts/start_cydex.sh -m "central"
if [ "$with_ldap" == "1" ]; then
    sh scripts/config_ldap.sh
fi

echo -e "\n"
echo "***********************************"
echo "* Cydex central controller is installed successfully. "
echo "***********************************"
echo -e "\n"
echo -e "\n"
