#/bin/bash

source scripts/resource_funcs.sh

show_help() {
    echo "Usage: $(basename $0) [options]"
    echo "  options:"
    echo "    -a, --with-archive    Install Cydex with Archive Mode"
    echo "    -l, --with-ldap       Install Cydex with LDAP Authentication"
    echo "    --external-mysql      Install Cydex with external MySQL database"
    echo "    --external-redis      Install Cydex with external Redis"
    echo "    --external-mongo      Install Cydex with external Mongo DB"
    echo "    --external-rabbitmq   Install Cydex with external RabbitMQ server"
}

unset with_ldap
unset with_archive
unset external_mysql
unset external_redis
unset external_mongo
unset external_rabbitmq
has_external_res=0
while getopts 'al-:' OPTION; do
    case "$OPTION" in
        a)
            with_archive=1
            ;;
        l)
            with_ldap=1
            ;;
        -)
            case "${OPTARG}" in
                with-archive)
                    with_archive=1
                    ;;
                with-ldap)
                    with_ldap=1
                    ;;
                external-mysql)
                    external_mysql=1
                    has_external_res=1
                    ;;
                external-redis)
                    external_redis=1
                    has_external_res=1
                    ;;
                external-mongo)
                    external_mongo=1
                    has_external_res=1
                    ;;
                external-rabbitmq)
                    external_rabbitmq=1
                    has_external_res=1
                    ;;
                *)
                    show_help
                    exit 1
                    ;;
            esac
            ;;
        *)
            show_help
            exit 1
            ;;
    esac
done


echo -e "\n\n\n\n\n
 ██████╗██╗   ██╗██████╗ ███████╗██╗  ██╗
██╔════╝╚██╗ ██╔╝██╔══██╗██╔════╝╚██╗██╔╝
██║      ╚████╔╝ ██║  ██║█████╗   ╚███╔╝
██║       ╚██╔╝  ██║  ██║██╔══╝   ██╔██╗
╚██████╗   ██║   ██████╔╝███████╗██╔╝ ██╗
 ╚═════╝   ╚═╝   ╚═════╝ ╚══════╝╚═╝  ╚═╝   version 3.4.2\n\n\n"

echo "This script will install or update all Cydex3 services on this host !!!"
echo -e "Continue? (Y/n) \c "
read answer
if !([ $answer == "Y" ] || [ $answer == "y" ]); then
    echo "Abort!"
    exit 0
fi

sh scripts/stop_cydex.sh

systemctl stop firewalld
systemctl disable firewalld

echo -e "\n"
echo "[Cydex] Install system components ... "
yum update -y --exclude=mongodb*
yum install -y epel-release unzip

if rpm -q nginx >/dev/null 2>&1; then
    echo "This script will Reinstall Nginx services on this host !!!"
    echo -e "Continue Reinstalling Nginx? (Y/n) \c "
    read answer
    if ([ $answer == "Y" ] || [ $answer == "y" ]); then
        systemctl stop nginx
        yum remove -y nginx
        yum install -y nginx
    fi
else
    yum install -y nginx
fi

yum install -y redis
# Install MYSQL
sh scripts/install_mysql.sh -e "$external_mysql"
#yum install -y python36 python36-devel
yum install -y iptables-services

if [ "$with_archive" == "1" ]; then
    # Install AWS CLI
    sh scripts/install_aws_cli.sh
    # Install MongoDB
    sh scripts/install_mongodb.sh -e "$external_mongo"
    if check_need_install_local_rabbitmq "$external_rabbitmq"; then
        # install RabbitMQ
        sh scripts/install_rabbitmq.sh
    fi
fi

echo -e "\n"
echo "[Cydex] Install Cydex components ... "
pkgs=`ls cydex_rpms/*.rpm`
for pkg in $pkgs
do
	rpm -Uvh --force $pkg
done

if [ "$with_archive" == "1" ]; then
    echo -e "\n"
    echo "[Cydex] Install Cydex Archive components ... "
    pkgs=`ls cydex_archive_rpms/*.rpm`
    for pkg in $pkgs
    do
        rpm -Uvh --force $pkg
    done
fi

echo -e "\n"
echo "[Cydex] Config system and Cydex ... "
sh scripts/disable_selinux.sh
sh scripts/config_nginx.sh
sh scripts/config_redis.sh -e "$external_redis" || exit $?
sh scripts/config_mysql.sh -a "$with_archive" -e "$external_mysql" || exit $?
sh scripts/sysctl_net.sh
sh scripts/config_rsyslog.sh
sh scripts/config_iptables.sh
if [ "$with_archive" == "1" ]; then
    sh scripts/config_zone_archive.sh -e "$external_mongo"
    sh scripts/config_node.sh -a
    sh scripts/config_archive.sh -e "$external_rabbitmq"
else
    sh scripts/config_node.sh
fi

sh scripts/release.sh

echo -e "\n"
echo "[Cydex] Start Cydex ... "
start_mode="all"
if [ "$with_archive" == "1" ]; then
    start_mode="$start_mode-archive"
fi
sh scripts/start_cydex.sh -m "$start_mode" -e "$has_external_res"

if [ "$with_ldap" == "1" ]; then
    sh scripts/config_ldap.sh
fi

echo -e "\n"
echo "***********************************"
echo "* Cydex is installed successfully. "
echo "***********************************"
echo -e "\n"
echo -e "\n"
