-- MySQL dump 10.13  Distrib 5.7.17, for Linux (x86_64)
--
-- Host: localhost    Database: db_cydex
-- ------------------------------------------------------
-- Server version	5.7.17-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `archive_file`
--

DROP TABLE IF EXISTS `archive_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_id` varchar(24) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` text NOT NULL,
  `type` int(11) NOT NULL,
  `size` bigint(20) NOT NULL,
  `mode` int(11) DEFAULT '0',
  `path_abs` text,
  `composition` int(11) DEFAULT '0',
  `origin_size` bigint(20) NOT NULL,
  `num_segs` int(11) NOT NULL,
  `seg_avg_size` bigint(20) NOT NULL,
  `storage` varchar(255) DEFAULT NULL,
  `storage_mode` int(11) DEFAULT NULL,
  `encryption_type` int(11) DEFAULT NULL,
  `encryption_block_size` int(11) DEFAULT NULL,
  `digest_method` varchar(32) DEFAULT NULL,
  `digest` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `file_create_at` datetime DEFAULT NULL,
  `file_update_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_file_file_id` (`file_id`),
  KEY `IDX_archive_file_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `archive_filejob`
--

DROP TABLE IF EXISTS `archive_filejob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_filejob` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `file_job_id` varchar(24) DEFAULT NULL,
  `file_id` varchar(24) NOT NULL,
  `operation` int(11) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `finished_size` bigint(20) NOT NULL DEFAULT '0',
  `state` int(11) NOT NULL DEFAULT '0',
  `segs_state_bitmap` varchar(255) DEFAULT NULL,
  `checked` int(11) NOT NULL DEFAULT '0',
  `finished_times` int(11) DEFAULT NULL,
  `file_job_create_at` datetime DEFAULT NULL,
  `file_job_update_at` datetime DEFAULT NULL,
  `tasks_count` int(11) DEFAULT NULL,
  `max_bitrate` bigint(20) DEFAULT NULL,
  `min_bitrate` bigint(20) DEFAULT NULL,
  `avg_bitrate` bigint(20) DEFAULT NULL,
  `peer_ips` varchar(255) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_filejob_filejob` (`file_id`,`operation`,`user_id`),
  UNIQUE KEY `UQE_archive_filejob_file_job_id` (`file_job_id`),
  KEY `IDX_archive_filejob_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `archive_package`
--

DROP TABLE IF EXISTS `archive_package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_package` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `package_id` varchar(24) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `num_files` int(11) NOT NULL DEFAULT '0',
  `size` bigint(20) NOT NULL DEFAULT '0',
  `origin_size` bigint(20) NOT NULL DEFAULT '0',
  `expires` bigint(20) DEFAULT NULL,
  `expires_after_download` bigint(20) DEFAULT NULL,
  `is_closed` tinyint(1) DEFAULT NULL,
  `is_broken` tinyint(1) DEFAULT NULL,
  `is_deleted` tinyint(1) DEFAULT NULL,
  `is_content_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_downloadable` tinyint(1) DEFAULT NULL,
  `downloadable_at` datetime DEFAULT NULL,
  `deleted_by` varchar(255) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `real_delete_expires` bigint(20) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `package_create_at` datetime DEFAULT NULL,
  `package_update_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_package_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `archive_packagejob`
--

DROP TABLE IF EXISTS `archive_packagejob`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `archive_packagejob` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `package_job_id` varchar(24) DEFAULT NULL,
  `package_id` varchar(24) NOT NULL,
  `operation` int(11) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `state` int(11) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `finished_times` int(11) NOT NULL DEFAULT '0',
  `finish_all_at` datetime DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` datetime DEFAULT NULL,
  `is_disable` tinyint(1) DEFAULT '0',
  `disable_by` varchar(24) DEFAULT NULL,
  `disable_at` datetime DEFAULT NULL,
  `package_job_create_at` datetime DEFAULT NULL,
  `package_job_update_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_archive_packagejob_pkgjob` (`package_id`,`operation`,`user_id`),
  UNIQUE KEY `UQE_archive_packagejob_package_job_id` (`package_job_id`),
  KEY `IDX_archive_packagejob_pkgjob2` (`operation`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `company`
--

DROP TABLE IF EXISTS `company`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company` (
  `id` varchar(24) NOT NULL,
  `name` varchar(255) NOT NULL,
  `pic_url` varchar(255) DEFAULT NULL,
  `token_api` varchar(1024) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `account_quota` int(11) DEFAULT NULL,
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `storage_quota` bigint(20) DEFAULT NULL,
  `archive_storage_quota` bigint(20) DEFAULT NULL,
  `license` varchar(255) DEFAULT NULL,
  `expired_at` datetime DEFAULT NULL,
  `short_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `company_zone`
--

DROP TABLE IF EXISTS `company_zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_zone` (
  `company_id` varchar(24) NOT NULL,
  `zone_id` varchar(24) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`company_id`,`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `file`
--

DROP TABLE IF EXISTS `file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file` (
  `id` varchar(24) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `size` bigint(11) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `path` text,
  `type` int(11) DEFAULT NULL,
  `mode` int(11) DEFAULT NULL,
  `path_abs` text,
  `composition` int(11) DEFAULT NULL,
  `origin_size` bigint(20) DEFAULT NULL,
  `num_segs` int(11) DEFAULT NULL,
  `seg_avg_size` bigint(20) DEFAULT NULL,
  `storage` varchar(255) DEFAULT NULL,
  `storage_mode` int(11) DEFAULT NULL,
  `encryption_type` int(11) DEFAULT NULL,
  `encryption_block_size` int(11) DEFAULT NULL,
  `digest_method` varchar(32) DEFAULT NULL,
  `digest` varchar(255) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_file_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `file_job`
--

DROP TABLE IF EXISTS `file_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `file_job` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `file_id` varchar(24) NOT NULL,
  `operation` int(11) NOT NULL COMMENT '1:upload 2：download',
  `package_id` varchar(24) DEFAULT NULL,
  `state` int(11) DEFAULT NULL COMMENT '0：idle 1：In the transmission 2：finish 3：interrupt',
  `finished_size` bigint(20) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `segs_state_bitmap` varchar(255) DEFAULT NULL,
  `checked` int(11) DEFAULT NULL,
  `finished_times` int(11) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_file_job_filejob` (`file_id`,`operation`,`user_id`),
  KEY `IDX_file_job_package_id` (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `js_user_quota_add`
--

DROP TABLE IF EXISTS `js_user_quota_add`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `js_user_quota_add` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dt` datetime DEFAULT NULL COMMENT 'Clearing time ',
  `user_id` varchar(24) DEFAULT NULL,
  `data` varchar(2000) DEFAULT NULL COMMENT 'Post-settlement data.json format，eg：[{ticket_id:"111",traffic:100,start_at:"2018-01-01 12:00:00",end_at:"2018-01-01 12:00:00",type:1,user_id:"001"},{} ...]',
  `available_traffic` bigint(20) DEFAULT NULL COMMENT 'Available flow after settlement',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Flow balance settlement log table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `language_pkg`
--

DROP TABLE IF EXISTS `language_pkg`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `language_pkg` (
  `lan_code` varchar(10) DEFAULT NULL COMMENT 'zh:Simplified Chinese zh-tw:Traditional Chinese en：english',
  `key` varchar(30) DEFAULT NULL,
  `value` varchar(50) DEFAULT NULL,
  UNIQUE KEY `idx_language_pkg_1` (`key`,`lan_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Language pack for multi-language edition';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `license_key`
--

DROP TABLE IF EXISTS `license_key`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `license_key` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `license_key` varchar(1000) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_file`
--

DROP TABLE IF EXISTS `log_file`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_file` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1：Uploaded successfully 2：Downloaded successfully 4:Deleted successfully',
  `state` int(11) DEFAULT NULL COMMENT '0:Idle 1：In the transmission 2:successfully ',
  `operation_at` datetime DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL COMMENT 'The size after compression',
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `finish_size` bigint(20) DEFAULT NULL COMMENT 'The size actually completed',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_op`
--

DROP TABLE IF EXISTS `log_op`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_op` (
  `id` varchar(24) NOT NULL,
  `operator_id` varchar(24) DEFAULT NULL COMMENT 'operator id',
  `operator_name` varchar(50) DEFAULT NULL COMMENT 'operator name',
  `to_user_id` varchar(24) DEFAULT NULL COMMENT 'People who are affected.',
  `to_user_name` varchar(50) DEFAULT NULL,
  `action` int(11) DEFAULT NULL COMMENT '// 1:login 2：logout 3：create package 4：delete package 5：upload 6：download 7：create project 8：delete project 9：active mini app 10:modify project 11:modify project members 12：modify project members permission 13：modify setting 14:Modify the default receiver 15：leave project 16:create group 17：modify group 18：modify group member 19：delete group 20：invite user 21：active user 22:Administrators kick out users 23：Background automatically deletes package (package expired) 24: Background automatically deletes the package (the package is expired after downloading) 25: Administrator add user\n-1:others',
  `details` varchar(500) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `operation_at` datetime DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `data` varchar(2000) DEFAULT NULL COMMENT '{"file_id":cxxx,"package_id":ddd}',
  `company_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Operation logs for login/logout/create pacakage/upload etc，\nBecause actions are different, some fields may not have values\nLog as long as the user has actions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_package`
--

DROP TABLE IF EXISTS `log_package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_package` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1：Uploaded successfully 2：Downloaded successfully',
  `state` int(11) DEFAULT NULL,
  `operation_at` datetime DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL COMMENT 'The size after compression.',
  `user_id_upload` varchar(24) DEFAULT NULL,
  `user_name_upload` varchar(50) DEFAULT NULL,
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `file_cnt` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='The log is not recorded until the operation is successful';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_task`
--

DROP TABLE IF EXISTS `log_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_task` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `allocated_bitrate` bigint(20) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1:upload 2：download',
  `state` int(11) DEFAULT NULL COMMENT '0：No transmission occurs 2：Successful end 3：Interrupt (transmission occurred)',
  `average_bitrate` bigint(20) DEFAULT NULL,
  `peer_ip` varchar(64) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `traffic` bigint(20) DEFAULT NULL,
  `task_id` varchar(24) DEFAULT NULL,
  `task_create_at` datetime DEFAULT NULL COMMENT 'task create at',
  `f2tp_backend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_task_hour`
--

DROP TABLE IF EXISTS `log_task_hour`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_task_hour` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `package_name` varchar(255) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `project_name` varchar(255) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1:upload 2：download',
  `allocated_bitrate` bigint(11) DEFAULT NULL,
  `max_bitrate` bigint(11) DEFAULT NULL,
  `min_bitrate` bigint(20) DEFAULT NULL,
  `average_bitrate` bigint(20) DEFAULT NULL,
  `peer_ip` varchar(64) DEFAULT NULL,
  `traffic` bigint(11) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `period` int(11) DEFAULT NULL,
  `size` bigint(20) DEFAULT NULL,
  `root_user_id` varchar(24) DEFAULT NULL,
  `root_user_name` varchar(50) DEFAULT NULL,
  `minute_bitrate` varchar(1000) DEFAULT NULL COMMENT 'Average code rate per minute during upload or download.Is an array of json, where each location represents a 1-minute average bitrate.Unit: k\neg. [343,545,66,11,4]',
  `task_id` varchar(24) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `f2tp_backend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mail_server_config`
--

DROP TABLE IF EXISTS `mail_server_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mail_server_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_enable` int(11) DEFAULT NULL COMMENT '0:Is not enabled\n1:enabled',
  `contact_name` varchar(100) DEFAULT NULL COMMENT 'The name of the contact that the user sees when they receive the mail',
  `description` varchar(100) DEFAULT NULL COMMENT 'description',
  `host` varchar(45) NOT NULL COMMENT 'Server address',
  `port` int(11) NOT NULL COMMENT 'port',
  `account` varchar(45) NOT NULL COMMENT 'account',
  `password` varchar(45) NOT NULL COMMENT 'password',
  `tls` int(11) DEFAULT NULL COMMENT '0:is not enabled\n1:enabled tls',
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `notification_record`
--

DROP TABLE IF EXISTS `notification_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `send` varchar(255) NOT NULL,
  `receiver` varchar(255) NOT NULL,
  `state` int(11) NOT NULL,
  `details` varchar(255) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package`
--

DROP TABLE IF EXISTS `package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package` (
  `id` varchar(24) NOT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `size` bigint(11) DEFAULT NULL,
  `notes` varchar(255) DEFAULT NULL,
  `num_files` int(11) DEFAULT NULL,
  `origin_size` bigint(20) DEFAULT NULL,
  `expires` bigint(20) DEFAULT NULL,
  `expires_after_download` bigint(20) DEFAULT NULL,
  `is_closed` tinyint(4) DEFAULT NULL,
  `is_broken` tinyint(4) DEFAULT NULL,
  `is_downloadable` tinyint(4) DEFAULT NULL,
  `downloadable_at` datetime DEFAULT NULL,
  `is_deleted` tinyint(4) DEFAULT NULL,
  `deleted_by` varchar(255) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `is_content_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `real_delete_expires` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_package_project_id` (`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `package_job`
--

DROP TABLE IF EXISTS `package_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package_job` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(24) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL COMMENT '1:upload  2：download',
  `state` int(11) DEFAULT NULL COMMENT '0：idle 1：in the transmission 2：finish 3：interrupt 100:Upload and download are complete',
  `is_read` tinyint(4) DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `finished_times` int(11) DEFAULT NULL,
  `finish_all_at` datetime DEFAULT NULL,
  `is_deleted` tinyint(4) DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `is_disable` tinyint(4) DEFAULT NULL,
  `disable_at` datetime DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `disable_by` varchar(24) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UQE_package_job_pkgjob` (`package_id`,`operation`,`user_id`),
  KEY `IDX_package_job_pkgjob2` (`operation`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project`
--

DROP TABLE IF EXISTS `project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project` (
  `id` varchar(24) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  `creater` varchar(24) DEFAULT NULL COMMENT 'project owner',
  `creater_name` varchar(45) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `pkg_expire` int(11) DEFAULT NULL,
  `pkg_expire_after_download` int(11) DEFAULT NULL,
  `allow_pkg_level_expiration` tinyint(4) DEFAULT NULL,
  `max_seg_num` bigint(20) DEFAULT NULL,
  `min_seg_size` bigint(20) DEFAULT NULL,
  `max_seg_size` bigint(20) DEFAULT NULL,
  `max_upload_bandwidth` bigint(20) DEFAULT NULL,
  `max_download_bandwidth` bigint(20) DEFAULT NULL,
  `save_mode` int(11) DEFAULT NULL COMMENT 'save mode，0:popular 1:complete',
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `pic_url` varchar(200) DEFAULT NULL,
  `company_id` varchar(24) NOT NULL,
  `storage_quota` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_1` (`create_at`),
  KEY `idx_project_2` (`creater`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_default_notification`
--

DROP TABLE IF EXISTS `project_default_notification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_default_notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `settings_id` varchar(24) NOT NULL,
  `mail` varchar(100) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_default_recipients`
--

DROP TABLE IF EXISTS `project_default_recipients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_default_recipients` (
  `user_id` varchar(24) NOT NULL COMMENT '0:project owner 1：manager 2：general user',
  `project_id` varchar(24) NOT NULL,
  `create_at` datetime DEFAULT NULL,
  `recipient_id` varchar(24) NOT NULL,
  UNIQUE KEY `idx_project_default_recipient_1` (`user_id`,`project_id`,`recipient_id`),
  KEY `idx_project_default_recipient_2` (`project_id`,`user_id`),
  KEY `idx_project_default_recipient_3` (`recipient_id`,`project_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_group`
--

DROP TABLE IF EXISTS `project_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_group` (
  `id` varchar(24) NOT NULL,
  `group_name` varchar(50) DEFAULT NULL,
  `project_id` varchar(24) NOT NULL COMMENT 'zh:Simplified Chinese zh-tw:Traditional Chinese en：english',
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `user_id` varchar(24) DEFAULT NULL COMMENT 'owner id',
  PRIMARY KEY (`id`),
  KEY `idx_project_group_1` (`project_id`,`user_id`),
  KEY `idx_project_group_2` (`user_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_group_member`
--

DROP TABLE IF EXISTS `project_group_member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_group_member` (
  `user_id` varchar(24) NOT NULL,
  `group_id` varchar(24) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_group_member_1` (`group_id`,`user_id`),
  KEY `idx_project_group_member_2` (`user_id`,`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_role_permission`
--

DROP TABLE IF EXISTS `project_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_role_permission` (
  `id` varchar(24) NOT NULL,
  `code` varchar(6) NOT NULL,
  `role_id` tinyint(4) NOT NULL,
  `value1` int(11) DEFAULT NULL,
  `value2` int(11) DEFAULT NULL,
  `is_allowed` tinyint(4) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_project_role_detail_2` (`role_id`,`code`),
  KEY `idx_project_role_detail_1` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_setting`
--

DROP TABLE IF EXISTS `project_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_setting` (
  `id` varchar(24) NOT NULL COMMENT '0:project owner 1：manager 2：general user',
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `operation` tinyint(4) DEFAULT '2' COMMENT '1.only upload 2.only download 3.Both',
  `upload_max_bps` bigint(20) DEFAULT '0',
  `download_max_bps` bigint(20) DEFAULT '0',
  `is_hide` int(11) DEFAULT NULL COMMENT '1:Hide (from other ordinary users)\n0:not hide',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_setting_pkg_events`
--

DROP TABLE IF EXISTS `project_setting_pkg_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_setting_pkg_events` (
  `id` varchar(24) NOT NULL,
  `code` varchar(50) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `settings_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_setting_pkg_events_1` (`settings_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_setting_pub_methods`
--

DROP TABLE IF EXISTS `project_setting_pub_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_setting_pub_methods` (
  `id` varchar(24) NOT NULL,
  `code` varchar(50) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `settings_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_project_setting_pub_methods_1` (`settings_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_user`
--

DROP TABLE IF EXISTS `project_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_user` (
  `user_id` varchar(24) NOT NULL,
  `project_id` varchar(24) NOT NULL,
  `role_id` tinyint(4) NOT NULL,
  `settings_id` varchar(24) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_project_user_1` (`project_id`,`user_id`),
  UNIQUE KEY `idx_project_user_2` (`user_id`,`project_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `security_group`
--

DROP TABLE IF EXISTS `security_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `security_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sg_id` varchar(45) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(200) DEFAULT NULL,
  `company_id` varchar(24) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_security_group_1` (`sg_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `security_group_detail`
--

DROP TABLE IF EXISTS `security_group_detail`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `security_group_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sg_id` varchar(45) NOT NULL,
  `sg_detail` varchar(200) DEFAULT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` int(11) DEFAULT NULL COMMENT 'Rule type\n1:device code\n2:ip\nCurrently only the device code is used',
  `description` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_security_group_detail_2` (`sg_id`,`sg_detail`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `server_config`
--

DROP TABLE IF EXISTS `server_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `server_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(45) NOT NULL COMMENT 'Server current version number such as: 1.0.0',
  `compatibility_s` int(11) NOT NULL COMMENT 'Compatible with the values start',
  `compatibility_e` int(11) NOT NULL COMMENT 'Compatible with the values end',
  `min_app_version` varchar(100) DEFAULT NULL COMMENT 'Minimum version for Client App required',
  `max_available_traffic` bigint(20) DEFAULT NULL COMMENT 'Maximum available traffic for free users, in Mb',
  `cydex_manager_code` varchar(24) DEFAULT NULL COMMENT 'Management center identification number, used to distinguish the local management center',
  `max_upload_bps` bigint(20) DEFAULT NULL COMMENT 'Default maximum upload bandwidth per person, in bits/s',
  `max_download_bps` bigint(20) DEFAULT NULL COMMENT 'Default maximum download bandwidth per person, in bits/s',
  `project_max_segs_num` int(11) DEFAULT NULL COMMENT 'Maximum number of slices',
  `project_min_seg_size` bigint(20) DEFAULT NULL COMMENT 'Minimum number of slices',
  `project_max_seg_size` bigint(20) DEFAULT NULL COMMENT 'Maximum slices byte',
  `calcu_traffic_interval` int(11) DEFAULT NULL COMMENT 'Real-time calculation of user traffic balance time interval, unit: minutes',
  `package_expire` int(11) DEFAULT NULL COMMENT 'Package expiration time, unit: second',
  `package_delete_expire` int(11) DEFAULT NULL COMMENT 'After the package is deleted, the time when the record of the package in the database is deleted.Unit: days, 15 days by default',
  `system_start_dt` datetime DEFAULT CURRENT_TIMESTAMP COMMENT 'Official operating time of the system.The initial time of all settlement and statements shall be based on this value.Anything less than this time is not considered official.',
  `overdraw_n` decimal(5,2) DEFAULT NULL COMMENT 'Overdraft flow coefficient\nOverdraft_flow=（The_registration_time*0.2+Total_purchase_flow*0.8）*n',
  `size_n` decimal(5,2) DEFAULT NULL COMMENT 'Available storage space coefficient\nAvailable_storage_space = The_remaining_traffic*n',
  `security_group` int(11) DEFAULT NULL COMMENT 'Enable security groups\n1:enabled\n0:Is not enabled',
  `server_name` varchar(100) DEFAULT NULL COMMENT 'server name',
  `server_type` varchar(100) DEFAULT NULL COMMENT 'server type',
  `with_archive` tinyint NOT NULL DEFAULT 0 COMMENT 'with archive',
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `hostname` varchar(100) DEFAULT NULL,
  `system_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `task`
--

DROP TABLE IF EXISTS `task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `task` (
  `id` varchar(24) NOT NULL,
  `user_id` varchar(255) DEFAULT NULL,
  `package_id` varchar(24) DEFAULT NULL,
  `file_id` varchar(24) DEFAULT NULL,
  `project_id` varchar(24) DEFAULT NULL,
  `zone_id` varchar(24) DEFAULT NULL,
  `operation` int(11) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `allocated_bitrate` bigint(11) DEFAULT NULL,
  `max_bitrate` bigint(11) DEFAULT NULL,
  `min_bitrate` bigint(11) DEFAULT NULL,
  `peer_ip` varchar(64) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `start_at` datetime DEFAULT NULL,
  `total_traffic` bigint(20) DEFAULT NULL,
  `total_bytes` bigint(20) DEFAULT NULL,
  `finish_at` datetime DEFAULT NULL,
  `avg_bitrate` bigint(20) DEFAULT NULL,
  `f2tp_backend` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_task_file_id` (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `user_id` varchar(24) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `time_zone` tinyint(4) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `mobile_phone` varchar(45) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `product_code` varchar(3) DEFAULT NULL COMMENT '1:From cydex registered 2：Users registered elsewhere',
  `pic_url` varchar(100) DEFAULT '',
  `account` varchar(45) DEFAULT NULL COMMENT 'User account, unique',
  `role` int(11) DEFAULT '0' COMMENT '0:advance user\n1:general user(Unable to create workspace)',
  `sg_id` varchar(45) DEFAULT NULL COMMENT 'The security group id',
  `password` varchar(45) NOT NULL,
  `is_complete` int(11) DEFAULT '1' COMMENT 'Whether to complete the registration mark 1:Registration completed 0:Incomplete registration',
  `company_id` varchar(24) NOT NULL,
  `company_role` int(11) DEFAULT NULL COMMENT 'The user role in the company 0:general user 1:advance user(reatable workspace) 2:manager(reatable workspace) 3:admin(reatable workspace)',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `idx_user_1` (`email`),
  UNIQUE KEY `idx_user_2` (`account`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_login`
--

DROP TABLE IF EXISTS `user_login`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_login` (
  `user_id` varchar(24) NOT NULL,
  `user_name` varchar(50) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `time_zone` tinyint(4) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `os_type` varchar(20) DEFAULT NULL,
  `os_detail` varchar(100) DEFAULT NULL,
  `last_login` datetime DEFAULT NULL COMMENT 'Last login time',
  `state` tinyint(4) DEFAULT NULL COMMENT 'mini app status 1：online 0：offline',
  PRIMARY KEY (`user_id`),
  KEY `idx_user_1` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_role_permission`
--

DROP TABLE IF EXISTS `user_role_permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_role_permission` (
  `id` varchar(24) NOT NULL,
  `code` varchar(6) NOT NULL,
  `role_id` tinyint(4) NOT NULL,
  `value1` int(11) DEFAULT NULL,
  `value2` int(11) DEFAULT NULL,
  `is_allowed` tinyint(4) DEFAULT NULL,
  `create_at` datetime DEFAULT NULL,
  `update_at` datetime DEFAULT NULL,
  `description` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_user_role_permission_2` (`role_id`,`code`),
  KEY `idx_user_role_permission_1` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `yw_black_list`
--

DROP TABLE IF EXISTS `yw_black_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `yw_black_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(24) NOT NULL COMMENT 'user id',
  `operate_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `operate_id` varchar(24) DEFAULT NULL COMMENT 'operator id(Operation and maintenance operator id，Not a user id)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_yw_black_list_1` (`user_id`),
  KEY `idx_yw_black_list_2` (`operate_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COMMENT='Tables beginning with yw are for operations\n';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `project_invite_record`
--

DROP TABLE IF EXISTS `project_invite_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `project_invite_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(24) NOT NULL,
  `user_id` varchar(24) NOT NULL,
  `email` varchar(50) NOT NULL,
  `create_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;


--
-- Table structure for table `zone`
--

DROP TABLE IF EXISTS `zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `zone` (
  `id` varchar(24) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `host` varchar(50) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  `secret_key` varchar(50) NOT NULL,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `type` tinyint(1) DEFAULT '0' COMMENT 'Data center type：\n0:public\n1:private\n2:Special purpose',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_zone_3` (`id`),
  UNIQUE KEY `idx_zone_5` (`host`),
  KEY `idx_zone_1` (`host`),
  KEY `idx_zone_2` (`secret_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-05-29 15:35:10
