#!/bin/bash

COMPANY_NAME=""
WORKSPACE_NAME=""
URL="http://127.0.0.1:9005/transfer_private/api/v1/reindex_archived_files"
    

usage() {
    echo "Usage: $0 [-c COMPANY_NAME] [-w WORKSPACE_NAME]" 1>&2
}

exit_abnormal() {
    usage
    exit 1
}

while getopts ":c:w:h" options; do 
    case "${options}" in
        c)
            COMPANY_NAME=${OPTARG}
            ;;
        w)
            WORKSPACE_NAME=${OPTARG}
            ;;
        h)                                    # If unknown (any other) option:
            exit_abnormal                       # Exit abnormally.
            ;;
        ?)
            echo "invalid arguments"
            exit_abnormal
            ;;
    esac
done

if [ "$COMPANY_NAME" == "" ] && [ "$WORKSPACE_NAME" != "" ]; then
    echo "'Company name' must be specified if 'workspace name' is provided" 1>&2
    exit_abnormal
fi

if [ "$COMPANY_NAME" != "" ] && [ "$WORKSPACE_NAME" == "" ]; then
    echo "Reindexing files for company ${COMPANY_NAME}"
    curl -X POST $URL \
        -H "Content-Type: application/json" \
        -d "{\"company_name\": \"$COMPANY_NAME\"}"

    exit 0
fi

if [ "$COMPANY_NAME" != "" ] && [ "$WORKSPACE_NAME" != "" ]; then
    echo "Reindexing files for company ${COMPANY_NAME} with workspace ${WORKSPACE_NAME}"

    curl -X POST $URL \
        -H "Content-Type: application/json" \
        -d "{\"company_name\": \"$COMPANY_NAME\", \"workspace_name\": \"$WORKSPACE_NAME\"}"

    exit 0
fi

echo "Reindexing files for all companies"
curl -X POST $URL
exit 0

    
