#!/bin/sh

echo "[Cydex] Config ulimit"
MAX_OPEN_FILES=`ulimit -n`
if [ "$MAX_OPEN_FILES" -lt "16384" ]; then
    echo "Your maximum open file number $MAX_OPEN_FILES is too small. Trying to set it to 16384."
    if [ -f "/etc/security/limits.d/20-nofile.conf" ]; then
        mv /etc/security/limits.d/20-nofile.conf /etc/security/limits.d/20-nofile.conf.bk.`date +%FT%T`
    fi
    cp config/ulimit/20-nofile.conf /etc/security/limits.d/

    if [ $LOGNAME == "root" ]; then
        PARGS=`ps -p $$ -o args=`
        if [ "$PARGS" == "bash" -o "$PARGS" == "sh" ]; then
            ulimit -n 16384
            exit 0
        fi
    fi

    echo 'You may need to reboot your server for this modification to take effect.'
fi
