#/bin/bash

PASSWORD_FILE=/etc/passwd-s3fs


echo -e "Please input the URL including port(Empty if not any)?\n-> \c"
read URL
if [[ $URL != "" ]]; then
    URL=",host=$URL"
fi

echo -e "Please input the bucket name?\n-> \c"
read BUCKET

echo -e "Please input the Zone of the s3 bucket(example ap-southeast-1)?\n-> \c"
read ZONE
if [[ $ZONE == "" ]]; then
    echo "Zone Cannot be empty!"
    exit 0
fi
ZONE=",endpoint=$ZONE"

echo -e "Please Input the User?\n-> \c"
read USER
if [[ $USER == "" ]]; then
    echo "User Cannot be empty!"
    exit 0
fi

echo -e "Please Input the Password?\n-> \c"
read PASSWORD
if [[ $PASSWORD == "" ]]; then
    echo "Password Cannot be empty!"
    exit 0
fi

echo -e "Please Input Folder where s3fs will be mounted?\n-> \c"
read MNT_FOLDER
if [[ $MNT_FOLDER == "" ]]; then
    echo "Mount Folder Cannot be empty!"
    exit 0
fi

if [[ ! -d "$MNT_FOLDER" ]];then
    echo "$MNT_FOLDER don't exists on your filesystem."
    exit 0
fi

echo -e "installing S3fs\n"
yum install -y s3fs-fuse

echo "Creating Configuration file in $PASSWORD_FILE"
echo "$USER:$PASSWORD" > $PASSWORD_FILE
chmod 600 $PASSWORD_FILE

CONFIG="s3fs#$BUCKET $MNT_FOLDER fuse _netdev,retries=5,connect_timeout=300,readwrite_timeout=120,dbglevel=info,nomultipart,enable_content_md5$URL$ZONE,use_path_request_style,umask=0000,mp_umask=0000,allow_other 0 0"

echo -e "The following values will be written in /etc/fstab"
echo $CONFIG
echo -e "Do you want to Continue? (Y/n): \c"
read answer
if ([ $answer == "Y" ] || [ $answer == "y" ]); then
    
    echo $CONFIG | sudo tee -a /etc/fstab

    mount $MNT_FOLDER
fi
