use db_cydex;

/*!40111 SET SQL_NOTES=0 */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `permissions` (
    `id` varchar(6) NOT NULL,
    `name` varchar(60) DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `UNIQUE` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `roles` (
    `id` int(4) NOT NULL,
    `name` varchar(60) DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `user_project_permissions` (
    `id` bigint(11) NOT NULL AUTO_INCREMENT,
    `user_id` varchar(24) DEFAULT NULL,
    `project_id` varchar(24) DEFAULT NULL,
    `role_id` int(4) DEFAULT NULL,
    `permission_id` varchar(6) DEFAULT NULL,
    `is_allowed` tinyint(4) DEFAULT '1',
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `user_project_role_permission` (`user_id`,`project_id`,`role_id`,`permission_id`),
    KEY `FK_Permissions_User_project_permissions` (`permission_id`),
    KEY `FK_Project_User_project_permissions` (`project_id`),
    KEY `FK_Roles_User_project_permissions` (`role_id`),
    CONSTRAINT `FK_Permissions_User_project_permissions` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `FK_Project_User_project_permissions` FOREIGN KEY (`project_id`) REFERENCES `project` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `FK_Roles_User_project_permissions` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT `FK_User_User_project_permissions` FOREIGN KEY (`user_id`) REFERENCES `user` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `storage_file` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `file_id` varchar(24) DEFAULT NULL,
    `path` text,
    `size` bigint(11) DEFAULT NULL,
    `user_id` varchar(24) DEFAULT NULL,
    `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
    `updated_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    `deleted_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `IDX_stored_file` (`file_id`),
    KEY `IDX_user` (`user_id`),
    CONSTRAINT `IDX_stored_file` FOREIGN KEY (`file_id`) REFERENCES `file` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
    CONSTRAINT `IDX_user` FOREIGN KEY (`user_id`) REFERENCES `user` (`user_id`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40111 SET SQL_NOTES=1 */;


DELIMITER ??
DROP PROCEDURE IF EXISTS db_cydex_migrate??
CREATE PROCEDURE db_cydex_migrate()
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'server_config' AND column_name = 'hostname') THEN
        ALTER TABLE `db_cydex`.`server_config` ADD COLUMN hostname varchar(45);
    END IF; 
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'server_config' AND column_name = 'server_type') THEN
        ALTER TABLE `db_cydex`.`server_config` ADD COLUMN server_type varchar(100) AFTER server_name;
        UPDATE `db_cydex`.`server_config` SET `server_type` = 'Arkhub';
    END IF; 
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'user' AND column_name = 'is_complete') THEN
        ALTER TABLE `db_cydex`.`user` ADD COLUMN is_complete int default 1 COMMENT 'Registration completed.1: registration completed 0: registration not completed';
    END IF;
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'project' AND column_name = 'storage_quota') THEN
        ALTER TABLE `db_cydex`.`project` ADD COLUMN storage_quota bigint(20);
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'project_setting_pkg_events' AND column_name = 'name') THEN
        ALTER TABLE `db_cydex`.`project_setting_pkg_events` DROP COLUMN name;
    END IF;
    IF EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'company' AND column_name = 'short_name') THEN
        ALTER TABLE `db_cydex`.`company` MODIFY COLUMN short_name varchar(255) DEFAULT null;
    END IF;
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE()  AND table_name = 'company' AND column_name = 'archive_storage_quota') THEN
        ALTER TABLE `db_cydex`.`company` ADD COLUMN archive_storage_quota bigint(20) DEFAULT null;
    END IF;
    IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = DATABASE() and TABLE_NAME='project_invite_record') THEN
        CREATE TABLE project_invite_record ( id int not null primary key auto_increment,project_id varchar(24) not null,user_id varchar(24) not null,email varchar(50) not null,create_at datetime)ENGINE=InnoDB DEFAULT CHARSET=utf8;
    END IF;
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'package_job' AND column_name = 'save_mode') THEN
        ALTER TABLE `db_cydex`.`package_job` ADD COLUMN save_mode int(11) DEFAULT NULL;
    END IF;
    INSERT IGNORE INTO `permissions` (`id`, `name`)
    VALUES
        ('001012','Archive'),
        ('001010','Check other people package information'),
        ('001001','Create package'),
        ('001002','Dealete/upadate other people packages'),
        ('001004','Delete members'),
        ('001008','Delete project'),
        ('001003','Invite members'),
        ('001009','Modify the basic information of the project'),
        ('001013','Retrieve'),
        ('001007','Set settings for other users'),
        ('001005','View preoject basic information'),
        ('001006','View project statistics'),
        ('001011','View the project log');

    INSERT IGNORE INTO `roles` (`id`, `name`)
    VALUES
          (0,'Company admin'),
          (1,'Workspace owner'),
          (2,'General user');

    -- Fix bug for server upgrading from Cydex version 9 to 18
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema = DATABASE() AND table_name = 'company' AND column_name = 'token_api') THEN
        ALTER TABLE `db_cydex`.`company` ADD COLUMN `token_api` varchar(1024) DEFAULT NULL AFTER `pic_url`;
    END IF;
END??
DELIMITER ;

CALL db_cydex_migrate();
