-- MySQL dump 10.13  Distrib 5.7.17, for Linux (x86_64)
--
-- Host: localhost    Database: db_zone
-- ------------------------------------------------------
-- Server version	5.7.17-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `auto_scaling_config`
--

DROP TABLE IF EXISTS `auto_scaling_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `auto_scaling_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `period_sleep` int(11) NOT NULL COMMENT 'djusted interval (in seconds) (this value indicates that the scheduler is dormant for the period of time if node has been adjusted to increase or decrease)',
  `period_schedule` int(11) NOT NULL COMMENT 'Time interval for performing node adjustments (in minutes) (that is, node adjustments are made at such long intervals)',
  `period_avg` int(11) NOT NULL COMMENT 'The time span required to calculate the current load (in seconds, Max. 60s)(if set to 5 seconds, the current upload speed/download speed/barrel concurrency value is the average of the last 5 seconds)\n',
  `period_idle` int(11) NOT NULL COMMENT 'Idle time threshold, used to determine whether node is idle, unit: minutes.(for example, if this value is set to 100, it means that if the upload or download speed is 0 for 100 minutes and the disk cache directory is empty, the node is considered idle and can be deleted.',
  `max_idle_node_cnt` int(11) NOT NULL COMMENT 'The number of free nodes that need to be kept (regardless of how many nodes are added or removed, the system will keep that many free nodes)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bucket`
--

DROP TABLE IF EXISTS `bucket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bucket` (
  `id` varchar(50) NOT NULL,
  `enable` tinyint(4) NOT NULL COMMENT '1: valid 0: invalid, indicating whether it is in the available state',
  `forbidden` tinyint(4) NOT NULL COMMENT 'Disabled 1:yes 0:no',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `config`
--

DROP TABLE IF EXISTS `config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `content` text,
  `create_at` datetime DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_UNIQUE` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_bucket_info`
--

DROP TABLE IF EXISTS `log_bucket_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_bucket_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bucket_id` varchar(45) NOT NULL,
  `up_cnt` int(11) DEFAULT NULL COMMENT 'Number of uploaded tasks',
  `down_cnt` int(11) DEFAULT NULL COMMENT 'Number of downloaded tasks',
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_log_node_info_1` (`create_at`,`bucket_id`),
  KEY `idx_log_node_info_2` (`bucket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Every once in a while, such as 2 minutes, record the node current state, such as the sum of the upload speeds of all tasks, etc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `log_node_info`
--

DROP TABLE IF EXISTS `log_node_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `log_node_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `node_id` varchar(45) NOT NULL,
  `up_rate` bigint(20) DEFAULT '0' COMMENT 'Sum of the upload speeds of all current tasks in kd/s',
  `down_rate` bigint(20) DEFAULT '0' COMMENT 'Sum of the download speeds of all current tasks in kb/s',
  `cache_size` bigint(20) DEFAULT '0' COMMENT 'Sum of caches occupied by all current tasks in kb',
  `cache_size_all` bigint(20) DEFAULT '0' COMMENT 'The total size of node cache in kb',
  `up_cnt` int(11) DEFAULT NULL COMMENT 'Number of uploaded tasks',
  `down_cnt` int(11) DEFAULT NULL COMMENT 'Number of downloaded tasks',
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_log_node_info_1` (`create_at`,`node_id`),
  KEY `idx_log_node_info_2` (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Every once in a while, such as 2 minutes, record the node current state, such as the sum of the upload speeds of all tasks, etc';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `manage_center`
--

DROP TABLE IF EXISTS `manage_center`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `manage_center` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codename` varchar(32) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `codename_UNIQUE` (`codename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `node`
--

DROP TABLE IF EXISTS `node`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `node` (
  `id` varchar(24) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `addr` varchar(255) DEFAULT NULL,
  `public_ip` varchar(255) DEFAULT NULL,
  `priority` tinyint(4) NOT NULL COMMENT '1: can not delete 0: can delete',
  `forbidden` tinyint(4) NOT NULL COMMENT 'Disabled 1:yes 0:no',
  `enable` tinyint(4) NOT NULL COMMENT 'true：effective false：invalid，Indicates whether the node is available',
  `rx_bandwidth` int(11) NOT NULL COMMENT 'Maximum upload bandwidth unit: Mb',
  `tx_bandwidth` int(11) NOT NULL COMMENT 'Maximum upload bandwidth unit: Mb',
  `last_login_at` datetime DEFAULT NULL,
  `last_update_at` datetime DEFAULT NULL,
  `create_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_at` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `description` varchar(100) DEFAULT NULL,
  `interface_addr` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-05-29 15:37:08
