#!/bin/sh

USERNAME=caton
PASSWORD=Caton_123
CREATE_MONGO_USER_SCRIPT_PATH=config/mongodb/create-user.js
MONGO_CONFIG=/etc/mongod.conf

echo "Configuring MongoDB with username and password."

cat <<EOF >${CREATE_MONGO_USER_SCRIPT_PATH}
db.createUser(
    {
        user: "${USERNAME}",
        pwd: "${PASSWORD}",
        roles: ["root"]
    }
)
EOF

# Set username & password in create-user.js
mongo admin $CREATE_MONGO_USER_SCRIPT_PATH

# Remove file when finish
rm $CREATE_MONGO_USER_SCRIPT_PATH

# Backup old config file if exist
if [ -e $MONGO_CONFIG ]
 then cp -a -- "$MONGO_CONFIG" "$MONGO_CONFIG-$(date +"%Y%m%d_%H%M%S")_backup"
fi

# Use config file with security option
cp config/mongodb/mongod-sample.conf $MONGO_CONFIG

systemctl restart mongod
