use cydex_admin;
DELIMITER ??
DROP PROCEDURE IF EXISTS cydex_admin_migrate??
CREATE PROCEDURE cydex_admin_migrate()
BEGIN
    IF NOT EXISTS (SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='auth_user' AND column_name='email') THEN
        ALTER TABLE `cydex_admin`.`auth_user` MODIFY COLUMN email varchar(254) NOT NULL UNIQUE;
    END IF;

    -- Fix bug for server upgrading from Cydex version 9 to 18
    IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.STATISTICS WHERE table_schema=DATABASE() AND table_name='auth_user' AND index_name='email_2') THEN
        ALTER TABLE `cydex_admin`.`auth_user` ADD CONSTRAINT `email_2` UNIQUE (email);
    END IF;
END??
DELIMITER ;

CALL cydex_admin_migrate();
