#!/bin/sh


echo "[Cydex] Initial mysql"

PASSWORD="Caton_123"

# make sure MySQL is using UTC time-zone
tz=`sed -n '/^default-time_zone/p' /etc/my.cnf`
if [ -z "$tz" ]; then
        sed -i '$a\default-time_zone = +0:00' /etc/my.cnf
fi

has_cydex_db=`mysql -u root -p$PASSWORD -e "SELECT * FROM information_schema.SCHEMATA where SCHEMA_NAME='db_cydex';" |wc -l`
if [ ${has_cydex_db} -gt 0 ]; then
    echo "Mysql is initialed for cydex, do the migratation."
    sed -i '/^default-time_zone/c\default-time_zone = +0:00' /etc/my.cnf
    systemctl restart mysqld
    sleep 1
    sh scripts/migrate_mysql.sh
    exit
fi

systemctl stop mysqld

if [ ! -f /etc/my.cnf.backup ]; then
    mv /etc/my.cnf /etc/my.cnf.backup
fi

cp -r config/my.cnf /etc/my.cnf
mv /var/log/mysqld.log /var/log/mysqld.log.backup >/dev/null 2>&1

systemctl enable mysqld
systemctl start mysqld

sleep 5

# initial the root password
## get the random password
orig_password=`cat /var/log/mysqld.log | grep "A temporary password" | awk -F "root@localhost: " '{print $2}'`
mysqladmin -u root -p${orig_password} password $PASSWORD >/dev/null 2>&1

echo "[Cydex] db: create databases for Cydex"
# create databases
mysql -u root -p$PASSWORD -e "CREATE DATABASE db_cydex DEFAULT CHARACTER SET utf8;"
mysql -u root -p$PASSWORD -e "CREATE DATABASE db_zone DEFAULT CHARACTER SET utf8;"
mysql -u root -p$PASSWORD -e "CREATE DATABASE db_statistics DEFAULT CHARACTER SET utf8;"
mysql -u root -p$PASSWORD -e "CREATE DATABASE cydex_admin DEFAULT CHARACTER SET utf8;"


echo "[Cydex] db: create tables for Cydex"
# create tables
mysql -u root -p$PASSWORD -e "use db_cydex; source config/sql/db_cydex.sql;"
mysql -u root -p$PASSWORD -e "use db_zone; source config/sql/db_zone.sql;"
mysql -u root -p$PASSWORD -e "use db_statistics; source config/sql/db_statistics.sql;"
mysql -u root -p$PASSWORD -e "use cydex_admin; source config/sql/cydex_admin.sql;"

echo "[Cydex] db: create default data for Cydex"
# insert default value
mysql -u root -p$PASSWORD -e "source config/sql/init_cydex.sql;"
mysql -u root -p$PASSWORD -e "source config/sql/init_zone.sql;"
mysql -u root -p$PASSWORD -e "source config/sql/init_statistics.sql;"


# echo "[Cydex] db: execute admin service migrate"
# # migration
# cd /opt/caton/cydex3/admin
# /opt/caton/cydex3/pyvenv/bin/python manage.py migrate

echo "[Cydex] db: do migrate at last"
sh scripts/migrate_mysql.sh

exit 0
